// app/profile/components/ProfileInfo.js
import React from "react";
import { View, Text, TouchableOpacity } from "react-native";
import { Feather } from "@expo/vector-icons";
import { useNavigation } from "expo-router";
import { styles, Colors } from "@/assets/styles/App.styles";

export const ProfileInfo = ({ user }) => {
  const navigation = useNavigation();

  return (
    <View style={styles.profilePageInfoContainer}>
      {/* Contact Information */}
      <View style={styles.profilePageInfoItem}>
        <Feather name="mail" size={20} color={Colors.primary} />
        <Text style={styles.profilePageHeaderText}>{user.email}</Text>
      </View>

      <View style={styles.profilePageInfoItem}>
        <Feather name="phone" size={20} color={Colors.primary} />
        <Text style={styles.profilePageHeaderText}>
          {user.phone_code} {user.phone}
        </Text>
      </View>

      {/* Daily Goal */}
      <View style={styles.profilePageInfoItem}>
        <Text style={styles.profilePageInfoTextQuestions}>Günlük Hedef:</Text>
        <Text style={styles.profilePageQuestionInfoText}>
          {user.daily_step_goal} Adım
        </Text>
      </View>

      {/* Edit Profile Button */}
      <TouchableOpacity
        onPress={() => navigation.navigate("profile/editProfile")}
        activeOpacity={0.6}
        style={styles.profilePageEditButton}
      >
        <Feather name="edit" size={20} color={Colors.white} />
        <Text style={styles.profilePageEditButtonText}>Profili Düzenle</Text>
      </TouchableOpacity>
    </View>
  );
};
