// app/profile/components/ReferralSection.js
import React from "react";
import { View, Text, TouchableOpacity } from "react-native";
import { Feather } from "@expo/vector-icons";
import { styles, Colors } from "@/assets/styles/App.styles";

export const ReferralSection = ({ user, points, copyToClipboard }) => {
  return (
    <View style={styles.profilePageInfoContainer}>
      {/* Header */}
      <View style={styles.referralHeaderContainer}>
        <Feather name="users" size={24} color={Colors.primary} />
        <Text style={styles.referralTitle}>Arkadaşlarını Davet Et</Text>
      </View>

      {/* Description */}
      <Text style={styles.referralDescription}>
        Arkadaşlarını davet et, her başarılı davet için 100 adım puan kazan!
      </Text>

      {/* Referral Code */}
      <View style={styles.referralCodeContainer}>
        <View style={styles.referralCodeBox}>
          <Text style={styles.referralCodeLabel}>Referans Kodun:</Text>
          <Text style={styles.referralCodeText}>{user.reference_code}</Text>
        </View>
        <TouchableOpacity
          style={styles.referralCopyButton}
          onPress={copyToClipboard}
          activeOpacity={0.7}
        >
          <Feather name="copy" size={24} color={Colors.white} />
        </TouchableOpacity>
      </View>

      {/* Stats Grid */}
      <View style={styles.referralStatsContainer}>
        <View style={styles.referralStatItem}>
          <Text style={styles.referralStatNumber}>
            {points?.total_points ?? 0}
          </Text>
          <Text style={styles.referralStatLabel}>Kazanılan Puan</Text>
        </View>
        <View style={styles.referralStatItem}>
          <Text style={styles.referralStatNumber}>{user.inviteCount}</Text>
          <Text style={styles.referralStatLabel}>Başarılı Davet</Text>
        </View>
      </View>
    </View>
  );
};
