// app/profile/components/SettingsSection.js
import React from "react";
import { View, Text, TouchableOpacity } from "react-native";
import { Feather } from "@expo/vector-icons";
import { useNavigation } from "expo-router";
import { styles, Colors } from "@/assets/styles/App.styles";

export const SettingsSection = () => {
  const navigation = useNavigation();

  return (
    <>
      <View style={styles.profilePageSettingsContainer}>
        <TouchableOpacity
          onPress={() => navigation.navigate("pages/profile/myOrders")}
          activeOpacity={0.6}
          style={styles.profilePageSettingsItem}
        >
          <Feather name="list" size={20} color={Colors.primary} />
          <Text style={styles.profilePageSettingsText}>Siparişlerim</Text>
        </TouchableOpacity>
        <TouchableOpacity
          onPress={() =>
            navigation.navigate("pages/profile/notificationSettings")
          }
          activeOpacity={0.6}
          style={styles.profilePageSettingsItem}
        >
          <Feather name="bell" size={20} color={Colors.primary} />
          <Text style={styles.profilePageSettingsText}>Bildirim Ayarları</Text>
        </TouchableOpacity>
        <TouchableOpacity
          onPress={() => navigation.navigate("pages/profile/helpAndSupport")}
          activeOpacity={0.6}
          style={styles.profilePageSettingsItem}
        >
          <Feather name="help-circle" size={20} color={Colors.primary} />
          <Text style={styles.profilePageSettingsText}>Yardım ve Destek</Text>
        </TouchableOpacity>
      </View>

      <TouchableOpacity
        activeOpacity={0.6}
        onPress={() => {
          navigation.reset({
            index: 0,
            routes: [{ name: "pages/login/loginScreen" }],
          });
        }}
        style={styles.profilePageLogoutButton}
      >
        <Feather name="log-out" size={20} color={Colors.danger} />
        <Text style={styles.profilePageLogoutButtonText}>Çıkış Yap</Text>
      </TouchableOpacity>
    </>
  );
};
