import React, { useState } from "react";
import {
  View,
  Text,
  ScrollView,
  TouchableOpacity,
  Linking,
  Modal,
  SectionList,
} from "react-native";
import { styles, Colors } from "@/assets/styles/App.styles";
import Topbar from "@/app/components/Topbar";
import Toolbar from "@/app/components/Toolbar";
import { Feather } from "@expo/vector-icons";

const HelpAndSupportScreen = () => {
  const [modalVisible, setModalVisible] = useState(false);
  const [selectedSection, setSelectedSection] = useState(null);

  const contentData = {
    faq: [
      {
        title: "Sıkça Sorulan Sorular",
        data: [
          {
            question: "Uygulamayı nasıl kullanabilirim?",
            answer:
              "Uygulamamızı kullanmak için öncelikle kayıt olmanız gerekmektedir...",
          },
          {
            question: "Şifremi unuttum ne yapmalıyım?",
            answer:
              'Şifrenizi sıfırlamak için giriş ekranındaki "Şifremi Unuttum" seçeneğini kullanabilirsiniz...',
          },
        ],
      },
    ],
    privacy: [
      {
        title: "Gizlilik Politikası",
        data: [
          {
            heading: "Veri Toplama",
            content: "Kullanıcılarımızdan topladığımız veriler...",
          },
          {
            heading: "Veri Kullanımı",
            content: "Topladığımız verileri nasıl kullanıyoruz...",
          },
        ],
      },
    ],
    terms: [
      {
        title: "Kullanım Şartları",
        data: [
          {
            heading: "Genel Kurallar",
            content: "Uygulamamızı kullanırken uymanız gereken kurallar...",
          },
          {
            heading: "Sorumluluklar",
            content: "Kullanıcıların sorumlulukları...",
          },
        ],
      },
    ],
  };

  const supportItems = [
    {
      title: "Sıkça Sorulan Sorular",
      icon: "help-circle",
      onPress: () => {
        setSelectedSection("faq");
        setModalVisible(true);
      },
    },
    {
      title: "Bize Ulaşın",
      icon: "mail",
      onPress: () => Linking.openURL("mailto:support@example.com"),
    },
    {
      title: "Whatsapp Destek",
      icon: "message-circle",
      onPress: () => Linking.openURL("https://wa.me/905555555555"),
    },
    {
      title: "Gizlilik Politikası",
      icon: "shield",
      onPress: () => {
        setSelectedSection("privacy");
        setModalVisible(true);
      },
    },
    {
      title: "Kullanım Şartları",
      icon: "file-text",
      onPress: () => {
        setSelectedSection("terms");
        setModalVisible(true);
      },
    },
  ];

  return (
    <View style={styles.MainContainer}>
      <Topbar title="Destek" />
      <ScrollView style={{ flex: 1 }}>
        <View style={{ padding: 15 }}>
          {supportItems.map((item, index) => (
            <TouchableOpacity
              key={index}
              style={{
                flexDirection: "row",
                alignItems: "center",
                padding: 15,
                borderBottomWidth: 1,
                borderBottomColor: Colors.secondary,
              }}
              onPress={item.onPress}
            >
              <Feather name={item.icon} size={24} color={Colors.primary} />
              <Text
                style={{
                  marginLeft: 15,
                  fontSize: 16,
                  color: Colors.tertiary,
                  fontFamily: "montmedium",
                }}
              >
                {item.title}
              </Text>
              <Feather
                name="chevron-right"
                size={24}
                color={Colors.secondary}
                style={{ marginLeft: "auto" }}
              />
            </TouchableOpacity>
          ))}
        </View>
      </ScrollView>
      <Modal
        transparent
        animationType="fade"
        onRequestClose={() => setModalVisible(false)}
        visible={modalVisible}
      >
        <View
          style={{
            flex: 1,
            justifyContent: "center",
            alignItems: "center",
            backgroundColor: "rgba(46, 77, 0, 0.3)",
            padding: 15,
          }}
        >
          <View
            style={{
              width: "100%",
              height: "80%",
              backgroundColor: Colors.white,
              borderRadius: 15,
              shadowColor: Colors.tertiary,
              shadowOffset: { width: 0, height: 4 },
              shadowOpacity: 0.15,
              shadowRadius: 6,
              elevation: 5,
            }}
          >
            <View
              style={{
                flexDirection: "row",
                justifyContent: "space-between",
                alignItems: "center",
                padding: 20,
                borderBottomWidth: 1,
                borderBottomColor: Colors.lightGray,
              }}
            >
              <Text
                style={{
                  fontSize: 20,
                  fontFamily: "montbold",
                  color: Colors.primary,
                }}
              >
                {selectedSection === "faq"
                  ? "Sıkça Sorulan Sorular"
                  : selectedSection === "privacy"
                  ? "Gizlilik Politikası"
                  : "Kullanım Şartları"}
              </Text>
              <TouchableOpacity
                onPress={() => setModalVisible(false)}
                style={{
                  padding: 5,
                }}
              >
                <Feather name="x-circle" size={28} color={Colors.primary} />
              </TouchableOpacity>
            </View>

            <SectionList
              sections={selectedSection ? contentData[selectedSection] : []}
              keyExtractor={(item, index) => index.toString()}
              renderItem={({ item }) => (
                <View
                  style={{
                    marginBottom: 20,
                    paddingHorizontal: 20,
                    backgroundColor: Colors.white,
                  }}
                >
                  <Text
                    style={{
                      fontSize: 16,
                      fontFamily: "montbold",
                      color: Colors.secondary,
                      marginBottom: 8,
                    }}
                  >
                    {item.question || item.heading}
                  </Text>
                  <Text
                    style={{
                      fontSize: 14,
                      fontFamily: "montregular",
                      color: Colors.tertiary,
                      lineHeight: 20,
                    }}
                  >
                    {item.answer || item.content}
                  </Text>
                </View>
              )}
              style={{ flex: 1 }}
              contentContainerStyle={{ paddingVertical: 15 }}
            />
          </View>
        </View>
      </Modal>
      <Toolbar selectedMenu={4} />
    </View>
  );
};

export default HelpAndSupportScreen;
