import React, { useState } from "react";
import { View, Text, ScrollView, Switch } from "react-native";
import { styles, Colors } from "@/assets/styles/App.styles";
import Topbar from "@/app/components/Topbar";
import Toolbar from "@/app/components/Toolbar";

const NotificationSettingsScreen = () => {
  const [settings, setSettings] = useState({
    orderNotifications: true,
    messageNotifications: false,
    achievementNotifications: false,
  });

  const toggleSwitch = (key) => {
    setSettings((prevState) => ({
      ...prevState,
      [key]: !prevState[key],
    }));
  };

  const renderSettingItem = (title, key) => (
    <View
      style={{
        flexDirection: "row",
        justifyContent: "space-between",
        alignItems: "center",
        padding: 15,
        borderBottomWidth: 1,
        borderBottomColor: Colors.secondary,
      }}
    >
      <Text
        style={{
          fontSize: 16,
          color: Colors.tertiary,
          fontFamily: "montmedium",
        }}
      >
        {title}
      </Text>
      <Switch
        trackColor={{ false: Colors.secondary, true: Colors.primary }}
        thumbColor={settings[key] ? Colors.white : Colors.white}
        onValueChange={() => toggleSwitch(key)}
        value={settings[key]}
      />
    </View>
  );

  return (
    <View style={styles.MainContainer}>
      <Topbar title="Bildirim Ayarları" />
      <ScrollView style={{ flex: 1 }}>
        <View style={{ padding: 15 }}>
          {renderSettingItem(
            "Adım Hedefleri Hatırlatıcıları",
            "achievementNotifications"
          )}
          {renderSettingItem("Mesaj Bildirimleri", "messageNotifications")}
          {renderSettingItem("Sipariş Bildirimleri", "orderNotifications")}
        </View>
      </ScrollView>
      <Toolbar selectedMenu={4} />
    </View>
  );
};

export default NotificationSettingsScreen;
