import React, { useState } from "react";
import { View, Text, ScrollView, Switch, TouchableOpacity } from "react-native";
import { styles, Colors } from "@/assets/styles/App.styles";
import Topbar from "@/app/components/Topbar";
import Toolbar from "@/app/components/Toolbar";
import { Feather } from "@expo/vector-icons";

const PrivacySettingsScreen = () => {
  const [settings, setSettings] = useState({
    profileVisibility: true,
    locationSharing: true,
    activityStatus: true,
  });

  const toggleSwitch = (key) => {
    setSettings((prevState) => ({
      ...prevState,
      [key]: !prevState[key],
    }));
  };

  const renderSettingItem = (title, description, key) => (
    <View
      style={{
        padding: 15,
        borderBottomWidth: 1,
        borderBottomColor: Colors.secondary,
      }}
    >
      <View
        style={{
          flexDirection: "row",
          justifyContent: "space-between",
          alignItems: "center",
        }}
      >
        <Text
          style={{
            fontSize: 16,
            color: Colors.tertiary,
            fontFamily: "montmedium",
          }}
        >
          {title}
        </Text>
        <Switch
          trackColor={{ false: Colors.secondary, true: Colors.primary }}
          thumbColor={settings[key] ? Colors.white : Colors.white}
          onValueChange={() => toggleSwitch(key)}
          value={settings[key]}
        />
      </View>
      <Text
        style={{
          fontSize: 12,
          color: Colors.secondary,
          marginTop: 5,
          fontFamily: "montregular",
        }}
      >
        {description}
      </Text>
    </View>
  );

  return (
    <View style={styles.MainContainer}>
      <Topbar title="Gizlilik Ayarları" />
      <ScrollView style={{ flex: 1 }}>
        <View>
          {renderSettingItem(
            "Profil Görünürlüğü",
            "Profilinizin diğer kullanıcılar tarafından görüntülenebilmesini kontrol eder.",
            "profileVisibility"
          )}
          {renderSettingItem(
            "Çevrimiçi Durum",
            "Çevrimiçi durumunuzun görünürlüğünü kontrol eder.",
            "activityStatus"
          )}
        </View>
      </ScrollView>
      <Toolbar selectedMenu={4} />
    </View>
  );
};

export default PrivacySettingsScreen;
