import { StyleSheet } from "react-native";
import { Dimensions } from "react-native";
import { Platform } from "react-native";

const { width, height } = Dimensions.get("window");

export const Colors = {
  primary: "#7AB52E",
  secondary: "#2E4D00",
  middle: "#558B0F",
  tertiary: "#1F1F1F",
  white: "#FFFFFF",
  danger: "#E63946",
  lightGray: "#E8E8E8",
  gradientLight: ["#FFFFFF", "#F5F9F1", "#EAF4E2"],

  success: "#2ECC71",
  warning: "#F1C40F",
  info: "#3498DB",
  accent: "#9B59B6",
  neutral: "#95A5A6",
  background: "#FAFAFA",
  surface: "#FFFFFF",
  border: "#DDDDDD",
};

export const styles = StyleSheet.create({
  MainContainer: {
    flex: 1,
    width: "100%",
  },

  WhiteMainContainer: {
    flex: 1,
    backgroundColor: "white",
    width: "100%",
  },

  LoginContainer: {
    flex: 1,
  },
  LoginSafeArea: {
    flex: 1,
  },
  LoginKeyboardAvoidingView: {
    flex: 1,
  },
  LoginScrollViewContent: {
    flexGrow: 1,
    padding: 20,
    justifyContent: "center",
  },
  LoginLogoContainer: {
    alignItems: "center",
    marginBottom: 30,
  },
  LoginLogo: {
    width: "80%",
    height: 100,
  },
  LoginTabContainer: {
    flexDirection: "row",
    marginBottom: 30,
    borderRadius: 10,
    overflow: "hidden",
    columnGap: 15,
  },
  LoginTab: {
    flex: 1,
    paddingVertical: 12,
    alignItems: "center",
    backgroundColor: Colors.white,
    borderWidth: 1,
    borderColor: Colors.primary,
    borderRadius: 10,
  },
  LoginActiveTab: {
    backgroundColor: Colors.primary,
  },
  LoginTabText: {
    fontSize: 16,
    color: Colors.primary,
    fontWeight: "600",
  },
  LoginActiveTabText: {
    color: Colors.white,
  },
  LoginInputContainer: {
    gap: 15,
  },
  LoginInput: {
    backgroundColor: Colors.white,
    borderRadius: 10,
  },
  LoginOptionsRow: {
    flexDirection: "row",
    justifyContent: "space-between",
    alignItems: "center",
    marginTop: 20,
  },
  LoginRememberMeContainer: {
    flexDirection: "row",
    alignItems: "center",
  },
  LoginCheckbox: {
    width: 20,
    height: 20,
    borderWidth: 2,
    borderColor: Colors.primary,
    borderRadius: 4,
    marginRight: 8,
    justifyContent: "center",
    alignItems: "center",
  },
  LoginCheckedBox: {
    backgroundColor: Colors.primary,
  },
  LoginRememberMeText: {
    color: Colors.tertiary,
    fontWeight: "500",
  },
  LoginForgotPasswordText: {
    color: Colors.primary,
    fontWeight: "500",
  },
  LoginButton: {
    backgroundColor: Colors.primary,
    padding: 15,
    borderRadius: 10,
    alignItems: "center",
    marginTop: 30,
  },
  LoginButtonText: {
    color: Colors.white,
    fontSize: 18,
    fontWeight: "bold",
  },
  LoginSignUpContainer: {
    marginTop: 20,
    alignItems: "center",
  },
  LoginSignUpText: {
    fontSize: 14,
    color: Colors.tertiary,
    marginBottom: 10,
  },
  LoginSignUpButton: {
    padding: 15,
    borderRadius: 10,
    alignItems: "center",
    backgroundColor: Colors.white,
    borderWidth: 1,
    borderColor: Colors.primary,
    marginTop: 10,
    width: "100%",
  },
  LoginSignUpButtonText: {
    color: Colors.primary,
    fontSize: 16,
    fontWeight: "bold",
  },

  RegisterContainer: {
    flex: 1,
    padding: 20,
    justifyContent: "center",
  },
  RegisterTitle: {
    fontSize: 24,
    fontFamily: "montbold",
    color: Colors.tertiary,
    marginBottom: 30,
    textAlign: "center",
  },
  RegisterInputContainer: {
    gap: 15,
  },
  RegisterInput: {
    backgroundColor: Colors.white,
    fontSize: 16,
    fontFamily: "montregular",
  },
  RegisterGenderContainer: {
    marginVertical: 10,
  },
  RegisterLabel: {
    fontSize: 16,
    fontFamily: "montmedium",
    color: Colors.tertiary,
    marginBottom: 8,
  },
  RegisterGenderOptions: {
    flexDirection: "row",
    gap: 40,
  },
  RegisterGenderOption: {
    flexDirection: "row",
    alignItems: "center",
    transform: [{ scale: 1.2 }],
  },
  RegisterButton: {
    backgroundColor: Colors.primary,
    padding: 15,
    borderRadius: 10,
    alignItems: "center",
    marginTop: 30,
  },
  RegisterButtonText: {
    color: Colors.white,
    fontSize: 16,
    fontFamily: "montbold",
  },
  RegisterBackButton: {
    padding: 15,
    borderRadius: 10,
    alignItems: "center",
    marginTop: 10,
  },
  RegisterBackButtonText: {
    color: Colors.primary,
    fontSize: 16,
    fontFamily: "montmedium",
  },
  RegisterCertificateButton: {
    backgroundColor: Colors.secondary,
    padding: 15,
    borderRadius: 10,
    alignItems: "center",
  },
  RegisterCertificateButtonText: {
    color: Colors.white,
    fontSize: 16,
    fontFamily: "montmedium",
  },
  RegisterCertificateCount: {
    color: Colors.tertiary,
    fontSize: 14,
    fontFamily: "montbold",
    textAlign: "center",
  },

  EmailVerificationText: {
    fontSize: 14,
    color: Colors.tertiary,
    textAlign: "center",
    marginBottom: 20,
    fontFamily: "montmedium",
    paddingHorizontal: 20,
  },

  questionPage: {
    flex: 1,
    justifyContent: "center",
    width: width,
    paddingHorizontal: 20,
  },
  questionText: {
    fontSize: 18,
    fontFamily: "montmedium",
    color: Colors.tertiary,
    marginBottom: 20,
    textAlign: "center",
  },
  paginationDots: {
    flexDirection: "row",
    justifyContent: "space-between",
    alignItems: "center",
    alignSelf: "center",
  },
  dot: {
    width: 8,
    height: 8,
    borderRadius: 4,
    marginHorizontal: 4,
  },
  navigationButtons: {
    flexDirection: "row",
    justifyContent: "space-between",
    paddingHorizontal: 20,
    marginBottom: 20,
    height: 50,
  },
  navButton: {
    padding: 15,
    borderRadius: 10,
    minWidth: 100,
    alignItems: "center",
    borderWidth: 1,
    borderColor: Colors.primary,
  },
  primaryButton: {
    backgroundColor: Colors.primary,
    borderWidth: 0,
  },
  navButtonText: {
    fontSize: 16,
    fontFamily: "montmedium",
    color: Colors.primary,
  },
  primaryButtonText: {
    color: Colors.white,
  },

  topbarContainer: {
    flexDirection: "row",
    alignItems: "center",
    justifyContent: "space-between",
    backgroundColor: Colors.primary,
    paddingVertical: 10,
    paddingHorizontal: 15,
    height: 65,
    paddingTop: 15,
  },
  topbarLogoContainer: {
    flex: 6,
    alignItems: "center",
    flexDirection: "row",
    justifyContent: "center",
  },
  topbarLogo: {
    width: 45,
    height: 45,
    resizeMode: "contain",
  },
  topbarMenuButton: {
    width: 34,
    height: 34,
    flex: 1,
    alignItems: "center",
    justifyContent: "center",
  },
  topbarTitle: {
    color: Colors.white,
    fontSize: 24,
    fontWeight: "bold",
  },
  topbarNotificationButton: {
    alignItems: "center",
    justifyContent: "center",
  },

  toolbarContainer: {
    flexDirection: "row",
    justifyContent: "space-around",
    alignItems: "center",
    backgroundColor: Colors.white,
    borderTopWidth: 1,
    borderTopColor: Colors.secondary,
    height: 75,
    padding: 5,
    columnGap: 5,
    paddingHorizontal: 15,
  },
  toolbarButton: {
    alignItems: "center",
    justifyContent: "center",
    flex: 1,
    paddingVertical: 10,
  },

  activeToolbarButton: {
    backgroundColor: Colors.primary,
    borderRadius: 10,
  },

  toolbarButtonText: {
    color: Colors.tertiary,
    fontSize: 13,
    fontFamily: "montmedium",
  },

  userHomepageContainer: {
    flex: 1,
    backgroundColor: Colors.white,
  },
  userHomepageScrollContainer: {
    flex: 1,
  },
  userHomepageGradient: {
    flex: 1,
    padding: 20,
  },
  userHomepageWelcomeContainer: {
    marginBottom: 20,
  },
  userHomepageWelcomeText: {
    fontSize: 24,
    color: Colors.secondary,
    fontFamily: "montbold",
  },
  userHomepageSubText: {
    fontSize: 16,
    color: Colors.tertiary,
    fontFamily: "montmedium",
  },
  userHomepageQuickActionsContainer: {
    flexDirection: "row",
    justifyContent: "space-between",
    marginBottom: 20,
  },
  userHomepageQuickActionButton: {
    backgroundColor: Colors.white,
    padding: 15,
    borderRadius: 10,
    alignItems: "center",
    width: "48%",
    boxShadow: Colors.tertiary,
    shadowOffset: { width: 0, height: 2 },
    shadowOpacity: 0.1,
    shadowRadius: 4,
    elevation: 3,
  },
  userHomepageQuickActionText: {
    marginTop: 5,
    color: Colors.secondary,
    fontFamily: "montmedium",
  },
  userHomepageNearbyContainer: {
    marginBottom: 20,
  },
  userHomepageSectionTitle: {
    fontSize: 18,
    color: Colors.secondary,
    marginBottom: 10,
    fontFamily: "montbold",
  },
  userHomepageNearbyItem: {
    backgroundColor: Colors.white,
    padding: 15,
    borderRadius: 10,
    marginBottom: 10,
    boxShadow: Colors.tertiary,
    shadowOffset: { width: 0, height: 2 },
    shadowOpacity: 0.1,
    shadowRadius: 4,
    elevation: 3,
  },
  userHomepageNearbyName: {
    fontSize: 16,
    fontFamily: "montmedium",
    color: Colors.tertiary,
  },
  userHomepageNearbyDistance: {
    fontSize: 14,
    color: Colors.primary,
    fontFamily: "montmedium",
  },
  userHomepageAppointmentsContainer: {
    marginBottom: 20,
  },
  userHomepageAppointmentItem: {
    backgroundColor: Colors.white,
    padding: 15,
    borderRadius: 10,
    marginBottom: 10,
    boxShadow: Colors.tertiary,
    shadowOffset: { width: 0, height: 2 },
    shadowOpacity: 0.1,
    shadowRadius: 4,
    elevation: 3,
  },
  userHomepageAppointmentName: {
    fontSize: 16,
    color: Colors.tertiary,
    fontFamily: "montbold",
  },
  userHomepageAppointmentDate: {
    fontSize: 14,
    color: Colors.tertiary,
    fontFamily: "montmedium",
  },

  profilePageContainer: {
    flex: 1,
    backgroundColor: Colors.white,
  },
  profilePageScrollContainer: {
    flex: 1,
  },
  profilePageGradient: {
    flex: 1,
    padding: 20,
  },
  profilePageHeaderContainer: {
    alignItems: "center",
    marginBottom: 20,
  },
  profilePageAvatar: {
    width: 100,
    height: 100,
    borderRadius: 50,
    marginBottom: 10,
    resizeMode: "contain",
  },
  profilePageName: {
    fontSize: 24,
    fontFamily: "montbold",
    color: Colors.tertiary,
  },
  profilePageInfoContainer: {
    backgroundColor: Colors.white,
    borderRadius: 10,
    padding: 15,
    marginBottom: 20,
    boxShadow: Colors.tertiary,
    shadowOffset: { width: 0, height: 2 },
    shadowOpacity: 0.1,
    shadowRadius: 4,
    elevation: 3,
  },
  profilePageInfoItem: {
    flexDirection: "row",
    alignItems: "center",
    marginBottom: 10,
  },
  profilePageHeaderText: {
    fontSize: 16,
    color: Colors.tertiary,
    fontFamily: "montmedium",
    marginLeft: 10,
  },

  profilePageInfoText: {
    fontSize: 16,
    color: Colors.tertiary,
    fontFamily: "montmedium",
  },

  profilePageInfoTextMedical: {
    fontSize: 18,
    color: Colors.tertiary,
    fontFamily: "montbold",
    textAlign: "center",
    marginBottom: 10,
  },

  profilePageQuestionInfoTextMedical: {
    fontSize: 15,
    color: Colors.tertiary,
    fontFamily: "montmedium",
    flex: 1,
    textAlign: "justify",
  },

  profilePageInfoTextQuestions: {
    fontSize: 16,
    color: Colors.tertiary,
    fontFamily: "montbold",
    textAlign: "left",
  },

  profilePageQuestionInfoText: {
    fontSize: 16,
    color: Colors.tertiary,
    fontFamily: "montmedium",
    flex: 1,
    textAlign: "right",
  },

  profilePageStatsContainer: {
    flexDirection: "row",
    justifyContent: "space-around",
    backgroundColor: Colors.white,
    borderRadius: 10,
    padding: 15,
    marginBottom: 20,
    boxShadow: Colors.tertiary,
    shadowOffset: { width: 0, height: 2 },
    shadowOpacity: 0.1,
    shadowRadius: 4,
    elevation: 3,
  },
  profilePageStatItem: {
    alignItems: "center",
  },
  profilePageStatNumber: {
    fontSize: 24,
    fontWeight: "bold",
    color: Colors.primary,
  },
  profilePageStatLabel: {
    fontSize: 14,
    color: Colors.tertiary,
    fontFamily: "montmedium",
  },
  profilePageEditButton: {
    flexDirection: "row",
    alignItems: "center",
    justifyContent: "center",
    backgroundColor: Colors.primary,
    borderRadius: 10,
    padding: 15,
    marginBottom: 20,
  },
  profilePageEditButtonText: {
    marginLeft: 10,
    fontSize: 16,
    fontFamily: "montbold",
    color: Colors.white,
  },
  profilePageSettingsContainer: {
    backgroundColor: Colors.white,
    borderRadius: 10,
    padding: 15,
    marginBottom: 20,
    boxShadow: Colors.tertiary,
    shadowOffset: { width: 0, height: 2 },
    shadowOpacity: 0.1,
    shadowRadius: 4,
    elevation: 3,
  },
  profilePageSettingsItem: {
    flexDirection: "row",
    alignItems: "center",
    paddingVertical: 10,
    /*  borderBottomWidth: 1,
         borderBottomColor: Colors.secondary, */
    marginVertical: 5,
  },
  profilePageSettingsText: {
    marginLeft: 10,
    fontSize: 14,
    color: Colors.tertiary,
    fontFamily: "montmedium",
  },
  profilePageLogoutButton: {
    flexDirection: "row",
    alignItems: "center",
    justifyContent: "center",
    backgroundColor: Colors.white,
    borderRadius: 10,
    padding: 15,
    borderWidth: 1,
    borderColor: Colors.danger,
  },
  profilePageLogoutButtonText: {
    marginLeft: 10,
    fontSize: 16,
    fontWeight: "600",
    color: Colors.danger,
    fontFamily: "montmedium",
  },

  diyetisyenItem: {
    flexDirection: "row",
    padding: 15,
    borderRadius: 10,
    backgroundColor: Colors.white,
    boxShadow: Colors.tertiary,
    shadowOffset: { width: 0, height: 2 },
    shadowOpacity: 0.1,
    shadowRadius: 4,
    elevation: 3,
    marginBottom: 10,
  },

  map: {
    width: "100%",
    height: "100%",
  },

  diyetisyenSpecialization: {
    flexDirection: "row",
    alignItems: "center",
    columnGap: 5,
  },

  chatHeader: {
    backgroundColor: Colors.primary,
    padding: 15,
    flexDirection: "row",
    alignItems: "center",
    gap: 15,
  },
  chatHeaderTitle: {
    color: Colors.white,
    fontSize: 18,
    fontFamily: "montbold",
  },
  chatMessages: {
    flex: 1,
    padding: 15,
  },
  messageContainer: {
    flexDirection: "row",
    marginBottom: 15,
    maxWidth: "80%",
  },
  sentMessage: {
    alignSelf: "flex-end",
  },
  receivedMessage: {
    alignSelf: "flex-start",
  },
  messageAvatar: {
    width: 35,
    height: 35,
    borderRadius: 17.5,
    marginRight: 10,
  },
  messageContent: {
    backgroundColor: Colors.white,
    padding: 10,
    borderRadius: 10,
    boxShadow: Colors.tertiary,
    shadowOffset: { width: 0, height: 2 },
    shadowOpacity: 0.1,
    shadowRadius: 4,
    elevation: 3,
  },
  messageText: {
    color: Colors.tertiary,
    fontSize: 14,
    fontFamily: "montregular",
  },
  messageTimestamp: {
    color: Colors.tertiary,
    fontSize: 12,
    fontFamily: "montregular",
    marginTop: 5,
  },
  messageImage: {
    width: 200,
    height: 150,
    borderRadius: 10,
    marginBottom: 5,
  },
  audioButton: {
    flexDirection: "row",
    alignItems: "center",
    backgroundColor: Colors.primary,
    padding: 10,
    borderRadius: 20,
    gap: 10,
  },
  audioText: {
    color: Colors.white,
    fontFamily: "montregular",
  },
  chatInputContainer: {
    flexDirection: "row",
    alignItems: "center",
    paddingHorizontal: 10,
    paddingVertical: 8,
    backgroundColor: Colors.white,
    borderTopWidth: 1,
    borderTopColor: Colors.lightGray,
    minHeight: 50,
    // iOS에서 키보드 위에 입력창이 보이도록 하기 위한 설정
    marginBottom: Platform.OS === "ios" ? 0 : 0,
  },

  chatInputField: {
    flex: 1,
    marginHorizontal: 10,
    paddingHorizontal: 15,
    paddingVertical: Platform.OS === "ios" ? 8 : 6,
    backgroundColor: Colors.lightGray,
    borderRadius: 20,
    fontSize: 16,
    maxHeight: 100,
  },

  chatInputActionButton: {
    padding: 5,
    justifyContent: "center",
    alignItems: "center",
  },

  chatInputSendButton: {
    padding: 5,
    justifyContent: "center",
    alignItems: "center",
  },

  chatInputPickedImage: {
    width: 32,
    height: 32,
    borderRadius: 16,
  },

  actionsContainer: {
    flexDirection: "row",
    justifyContent: "space-between",
    alignItems: "center",
    marginLeft: 5,
    marginRight: 5,
  },

  ChatPageInputToolbar: {
    justifyContent: "center",
    alignItems: "center",
    borderTopWidth: 1,
    borderTopColor: "#e0e0e0",
    backgroundColor: "#fff",
    paddingHorizontal: 8,
  },

  ChatPageComposerInput: {
    borderRadius: 16,
    backgroundColor: Colors.lightGray,
    paddingHorizontal: 12,
    padding: 5,
    marginTop: 10,
    marginLeft: 5,
    marginRight: 5,
    fontSize: 14,
  },

  ChatPageSendButton: {
    justifyContent: "center",
    alignItems: "center",
    marginRight: 10,
    marginLeft: 10,
  },

  ChatPageSystemMessageWrapper: {
    borderRadius: 15,
    padding: 10,
  },
  ChatPageSystemMessageText: {
    opacity: 0.8,
    fontSize: 14,
  },

  ChatPageContainer: {
    flex: 1,
    backgroundColor: Colors.white,
  },

  ChatPageMessageAudio: {
    width: 100,
    height: 100,
    borderRadius: 50,
    justifyContent: "center",
    alignItems: "center",
  },

  ChatPageHeader: {
    flexDirection: "row",
    alignItems: "center",
    backgroundColor: Colors.primary,
    padding: 15,
  },

  DoctorProfileMainButton: {
    backgroundColor: Colors.primary,
    padding: 15,
    borderRadius: 10,
    alignItems: "center",
    justifyContent: "center",
  },

  DoctorProfileMainText: {
    color: Colors.white,
    fontSize: 16,
    fontFamily: "montbold",
    textAlign: "center",
  },

  DoctorProfilePageAvatar: {
    width: 110,
    height: 110,
    borderRadius: 100,
    marginBottom: 10,
    resizeMode: "cover",
  },

  sendRequestButton: {
    width: "100%",
    backgroundColor: Colors.secondary,
    borderRadius: 10,
    padding: 15,
    alignItems: "center",
    justifyContent: "center",
    marginBottom: 20,
    flexDirection: "row",
    columnGap: 10,
  },

  sendRequestButtonText: {
    color: Colors.white,
    fontSize: 16,
    fontFamily: "montbold",
  },

  SendRequestButton: {
    backgroundColor: Colors.primary,
    padding: 15,
    borderRadius: 10,
    alignItems: "center",
    marginTop: 30,
    flexDirection: "row",
    justifyContent: "center",
  },

  myLocationButton: {
    backgroundColor: Colors.middle,
    padding: 10,
    borderRadius: 100,
    width: "100%",
    alignItems: "center",
    justifyContent: "center",
  },

  myLocationButtonText: {
    color: Colors.white,
    fontSize: 16,
    fontFamily: "montbold",
  },
  profilePageEditAvatarButton: {
    position: "absolute",
    right: 0,
    bottom: 0,
    backgroundColor: Colors.primary,
    width: 36,
    height: 36,
    borderRadius: 18,
    justifyContent: "center",
    alignItems: "center",
    borderWidth: 3,
    borderColor: Colors.white,
  },

  statsCard: {
    flex: 1,
    minWidth: "45%",
    backgroundColor: Colors.white,
    padding: 15,
    borderRadius: 10,
    boxShadow: Colors.tertiary,
    shadowOffset: { width: 0, height: 2 },
    shadowOpacity: 0.1,
    shadowRadius: 4,
    elevation: 3,
    alignItems: "center",
  },
  statsNumber: {
    fontSize: 24,
    fontFamily: "montbold",
    color: Colors.primary,
    marginVertical: 5,
  },
  statsLabel: {
    fontSize: 14,
    fontFamily: "montmedium",
    color: Colors.secondary,
  },
  statsLimit: {
    fontSize: 12,
    fontFamily: "montregular",
    color: Colors.tertiary,
    marginTop: 5,
  },
  quickActionsContainer: {
    flexDirection: "row",
    justifyContent: "space-between",
    marginVertical: 10,
  },
  quickActionButton: {
    flex: 1,
    backgroundColor: Colors.primary,
    padding: 15,
    borderRadius: 10,
    alignItems: "center",
    marginHorizontal: 5,
  },
  quickActionText: {
    color: Colors.white,
    marginTop: 5,
    fontSize: 12,
    fontFamily: "montmedium",
  },
  sectionTitle: {
    fontSize: 18,
    fontFamily: "montbold",
    color: Colors.primary,
    marginBottom: 10,
  },
  emptyText: {
    textAlign: "center",
    color: Colors.secondary,
    fontFamily: "montregular",
    marginTop: 20,
  },

  calendarContainer: {
    padding: 15,
    backgroundColor: Colors.white,
  },
  timeSlot: {
    padding: 15,
    borderRadius: 10,
    marginVertical: 5,
    backgroundColor: Colors.white,
    boxShadow: Colors.tertiary,
    shadowOffset: { width: 0, height: 2 },
    shadowOpacity: 0.1,
    shadowRadius: 4,
    elevation: 3,
  },
  timeSlotTime: {
    fontSize: 16,
    fontFamily: "montbold",
    color: Colors.primary,
  },
  timeSlotClient: {
    fontSize: 14,
    fontFamily: "montmedium",
    color: Colors.secondary,
    marginTop: 5,
  },
  timeSlotType: {
    fontSize: 12,
    fontFamily: "montregular",
    color: Colors.tertiary,
  },
  timeSlotStatus: {
    position: "absolute",
    right: 12,
    top: 12,
  },
  timeSlotLegend: {
    flexDirection: "row",
    justifyContent: "space-around",
    padding: 15,
    marginTop: 10,
  },
  legendItem: {
    flexDirection: "row",
    alignItems: "center",
  },
  legendDotAppointments: {
    width: 10,
    height: 10,
    borderRadius: 100,
    marginRight: 5,
  },
  legendText: {
    fontSize: 12,
    fontFamily: "montregular",
    color: Colors.secondary,
  },
  selectedDateText: {
    fontSize: 18,
    fontFamily: "montbold",
    color: Colors.primary,
    marginVertical: 15,
  },
  timeSlotsContainer: {
    marginTop: 15,
  },

  clientCard: {
    backgroundColor: Colors.white,
    borderRadius: 15,
    padding: 15,
    marginBottom: 15,
    boxShadow: Colors.tertiary,
    shadowOffset: { width: 0, height: 2 },
    shadowOpacity: 0.1,
    shadowRadius: 4,
    elevation: 3,
  },
  clientHeader: {
    flexDirection: "row",
    alignItems: "center",
    marginBottom: 15,
  },
  clientAvatar: {
    width: 50,
    height: 50,
    borderRadius: 25,
  },
  clientInfo: {
    flex: 1,
    marginLeft: 15,
  },
  clientName: {
    fontSize: 16,
    fontFamily: "montbold",
    color: Colors.primary,
  },
  clientProgram: {
    fontSize: 14,
    fontFamily: "montregular",
    color: Colors.secondary,
  },
  progressContainer: {
    alignItems: "center",
  },
  progressText: {
    fontSize: 14,
    fontFamily: "montbold",
    color: Colors.primary,
    marginBottom: 5,
  },
  progressBar: {
    width: 50,
    height: 4,
    backgroundColor: Colors.tertiary + "20",
    borderRadius: 2,
  },
  progressFill: {
    height: "100%",
    backgroundColor: Colors.primary,
    borderRadius: 2,
  },
  clientStats: {
    justifyContent: "space-between",
    marginBottom: 15,
    rowGap: 5,
    width: "100%",
  },
  statItem: {
    flexDirection: "row",
    alignItems: "center",
  },
  statText: {
    marginLeft: 5,
    fontSize: 12,
    fontFamily: "montregular",
    color: Colors.secondary,
  },
  clientActions: {
    flexDirection: "row",
    justifyContent: "space-between",
  },
  actionButton: {
    flex: 1,
    flexDirection: "row",
    alignItems: "center",
    justifyContent: "center",
    backgroundColor: Colors.primary,
    padding: 10,
    borderRadius: 8,
    marginHorizontal: 5,
  },
  actionButtonText: {
    color: Colors.white,
    marginLeft: 5,
    fontSize: 12,
    fontFamily: "montmedium",
  },
  searchContainer: {
    flexDirection: "row",
    alignItems: "center",
    backgroundColor: Colors.white,
    padding: 10,
    marginHorizontal: 15,
    marginVertical: 10,
    borderRadius: 10,
    borderWidth: 1,
    borderColor: Colors.tertiary,
    borderRadius: 10,
    padding: 10,
  },
  searchInput: {
    flex: 1,
    marginLeft: 10,
    fontFamily: "montregular",
  },
  clientListContainer: {
    padding: 15,
  },

  dietProgramContainer: {
    padding: 15,
  },
  dietFormSection: {
    marginBottom: 20,
    gap: 10,
  },
  dietInput: {
    backgroundColor: Colors.white,
    padding: 12,
    borderRadius: 8,
    fontFamily: "montregular",
    borderBottomWidth: 1,
    marginBottom: 10,
    borderBottomColor: Colors.tertiary,
  },
  mealsContainer: {
    gap: 15,
  },
  mealCard: {
    backgroundColor: Colors.white,
    padding: 15,
    borderRadius: 10,
    boxShadow: Colors.tertiary,
    shadowOffset: { width: 0, height: 2 },
    shadowOpacity: 0.1,
    shadowRadius: 4,
    elevation: 3,
  },
  mealHeader: {
    flexDirection: "row",
    justifyContent: "space-between",
    marginBottom: 15,
  },
  mealNameInput: {
    flex: 2,
    fontFamily: "montbold",
    fontSize: 16,
    color: Colors.primary,
  },
  mealTimeInput: {
    flex: 1,
    textAlign: "right",
    fontFamily: "montregular",
    color: Colors.secondary,
  },
  foodItem: {
    flexDirection: "row",
    gap: 10,
    marginBottom: 10,
  },
  foodInput: {
    flex: 2,
    backgroundColor: Colors.tertiary + "10",
    padding: 8,
    borderRadius: 6,
    fontFamily: "montregular",
  },
  portionInput: {
    flex: 1,
    backgroundColor: Colors.tertiary + "10",
    padding: 8,
    borderRadius: 6,
    fontFamily: "montregular",
  },
  calorieInput: {
    flex: 1,
    backgroundColor: Colors.tertiary + "10",
    padding: 8,
    borderRadius: 6,
    fontFamily: "montregular",
  },
  addFoodButton: {
    flexDirection: "row",
    alignItems: "center",
    padding: 10,
    borderRadius: 6,
    borderWidth: 1,
    borderColor: Colors.primary,
    marginVertical: 10,
  },
  addFoodButtonText: {
    marginLeft: 10,
    color: Colors.primary,
    fontFamily: "montmedium",
  },
  mealNotes: {
    backgroundColor: Colors.tertiary + "10",
    padding: 10,
    borderRadius: 6,
    minHeight: 60,
    fontFamily: "montregular",
    marginTop: 10,
  },
  addMealButton: {
    flexDirection: "row",
    alignItems: "center",
    justifyContent: "center",
    padding: 15,
    borderRadius: 10,
    borderWidth: 2,
    borderStyle: "dashed",
    borderColor: Colors.primary,
  },
  addMealButtonText: {
    marginLeft: 10,
    color: Colors.primary,
    fontFamily: "montbold",
  },
  actionButtons: {
    flexDirection: "row",
    justifyContent: "space-between",
    marginTop: 20,
    gap: 10,
  },

  blogContainer: {
    padding: 15,
  },
  blogImagePicker: {
    width: "100%",
    height: 200,
    backgroundColor: Colors.tertiary + "10",
    borderRadius: 10,
    justifyContent: "center",
    alignItems: "center",
    marginBottom: 15,
  },
  blogImage: {
    width: "100%",
    height: "100%",
    borderRadius: 10,
  },
  blogImagePickerText: {
    marginTop: 10,
    color: Colors.secondary,
    fontFamily: "montmedium",
  },
  blogTitleInput: {
    backgroundColor: Colors.white,
    padding: 15,
    borderRadius: 10,
    fontSize: 18,
    fontFamily: "montbold",
    marginBottom: 15,
    borderWidth: 1,
    borderColor: "lightgrey",
  },
  blogContentInput: {
    backgroundColor: Colors.white,
    padding: 15,
    borderRadius: 10,
    minHeight: 200,
    fontFamily: "montregular",
    marginBottom: 15,
    borderWidth: 1,
    borderColor: "lightgrey",
  },
  blogTagsContainer: {
    marginBottom: 15,
  },
  blogTagsTitle: {
    fontSize: 16,
    fontFamily: "montbold",
    color: Colors.primary,
    marginBottom: 10,
  },
  blogTags: {
    flexDirection: "row",
    flexWrap: "wrap",
    gap: 10,
    marginBottom: 10,
  },
  blogTag: {
    flexDirection: "row",
    alignItems: "center",
    backgroundColor: Colors.primary,
    paddingVertical: 5,
    paddingHorizontal: 10,
    borderRadius: 15,
    gap: 5,
  },
  blogTagText: {
    color: Colors.white,
    fontFamily: "montmedium",
    maxWidth: "95%",
  },
  blogTagInput: {
    backgroundColor: Colors.white,
    padding: 10,
    borderRadius: 10,
    fontFamily: "montregular",
    flex: 1,
  },
  blogActions: {
    flexDirection: "row",
    justifyContent: "space-between",
    gap: 10,
  },
  blogActionButton: {
    flex: 1,
    flexDirection: "row",
    alignItems: "center",
    justifyContent: "center",
    backgroundColor: Colors.primary,
    padding: 15,
    borderRadius: 10,
    gap: 10,
  },
  blogActionButtonText: {
    color: Colors.white,
    fontFamily: "montmedium",
  },

  packageContainer: {
    padding: 15,
  },
  durationToggle: {
    flexDirection: "row",
    backgroundColor: Colors.tertiary + "20",
    borderRadius: 10,
    padding: 5,
    marginBottom: 20,
  },
  durationButton: {
    flex: 1,
    padding: 10,
    alignItems: "center",
    borderRadius: 8,
  },
  durationButtonActive: {
    backgroundColor: Colors.white,
  },
  durationButtonText: {
    fontFamily: "montmedium",
    color: Colors.secondary,
  },
  durationButtonTextActive: {
    color: Colors.primary,
  },
  packageCard: {
    backgroundColor: Colors.white,
    borderRadius: 15,
    padding: 20,
    marginBottom: 15,
    borderWidth: 2,
    borderColor: "transparent",
  },
  packageCardSelected: {
    borderColor: Colors.primary,
  },
  packageName: {
    fontSize: 20,
    fontFamily: "montbold",
    color: Colors.primary,
    marginBottom: 10,
  },
  packagePrice: {
    fontSize: 24,
    fontFamily: "montbold",
    color: Colors.secondary,
    marginBottom: 15,
  },
  packageDuration: {
    fontSize: 16,
    fontFamily: "montregular",
    color: Colors.tertiary,
  },
  packageFeatures: {
    gap: 10,
  },
  featureItem: {
    flexDirection: "row",
    alignItems: "center",
    gap: 10,
  },
  featureText: {
    fontFamily: "montregular",
    color: Colors.secondary,
  },
  purchaseButton: {
    flexDirection: "row",
    alignItems: "center",
    justifyContent: "center",
    backgroundColor: Colors.primary,
    padding: 15,
    borderRadius: 10,
    gap: 10,
    marginTop: 20,
  },
  purchaseButtonText: {
    color: Colors.white,
    fontFamily: "montbold",
    fontSize: 16,
  },

  chatTabContainer: {
    flexDirection: "row",
    padding: 15,
    borderBottomWidth: 1,
    borderBottomColor: Colors.tertiary + "20",
  },
  chatTab: {
    flex: 1,
    flexDirection: "row",
    alignItems: "center",
    justifyContent: "center",
    padding: 10,
    gap: 10,
    borderRadius: 8,
  },
  chatTabActive: {
    backgroundColor: Colors.primary + "10",
  },
  chatTabText: {
    fontFamily: "montmedium",
    color: Colors.secondary,
  },
  chatTabTextActive: {
    color: Colors.primary,
  },
  chatList: {
    flex: 1,
  },
  chatItem: {
    flexDirection: "row",
    padding: 15,
    borderBottomWidth: 1,
    borderBottomColor: Colors.tertiary + "10",
  },
  chatAvatar: {
    width: 50,
    height: 50,
    borderRadius: 25,
  },
  chatContent: {
    flex: 1,
    marginLeft: 15,
  },
  chatHeader: {
    flexDirection: "row",
    justifyContent: "space-between",
    alignItems: "center",
  },
  chatName: {
    fontSize: 16,
    fontFamily: "montbold",
    color: Colors.primary,
  },
  chatTime: {
    fontSize: 12,
    fontFamily: "montregular",
    color: Colors.tertiary,
  },
  chatFooter: {
    flexDirection: "row",
    justifyContent: "space-between",
    alignItems: "center",
    marginTop: 5,
  },
  chatLastMessage: {
    flex: 1,
    fontSize: 14,
    fontFamily: "montregular",
    color: Colors.secondary,
  },
  unreadBadge: {
    backgroundColor: Colors.primary,
    borderRadius: 12,
    minWidth: 24,
    height: 24,
    alignItems: "center",
    justifyContent: "center",
    marginLeft: 10,
  },
  unreadText: {
    color: Colors.white,
    fontSize: 12,
    fontFamily: "montbold",
  },
  remainingMessages: {
    fontSize: 12,
    fontFamily: "montregular",
    color: Colors.tertiary,
    marginTop: 5,
  },
  createGroupButton: {
    flexDirection: "row",
    alignItems: "center",
    justifyContent: "center",
    backgroundColor: Colors.primary,
    padding: 15,
    margin: 15,
    borderRadius: 10,
    gap: 10,
  },
  createGroupButtonText: {
    color: Colors.white,
    fontFamily: "montbold",
    fontSize: 16,
  },

  profileImageContainer: {
    position: "relative",
    marginBottom: 10,
  },
  editIconContainer: {
    position: "absolute",
    bottom: 0,
    right: 0,
    backgroundColor: Colors.primary,
    width: 32,
    height: 32,
    borderRadius: 16,
    justifyContent: "center",
    alignItems: "center",
    borderWidth: 2,
    borderColor: Colors.white,
  },
  profileProfession: {
    color: Colors.secondary,
    fontSize: 16,
    fontFamily: "montsemibold",
    marginTop: 5,
  },
  statItem: {
    alignItems: "center",
    flex: 1,
  },
  statItemClientManagement: {
    flexDirection: "row",
    alignItems: "center",
  },
  statNumber: {
    color: Colors.primary,
    fontSize: 18,
    fontFamily: "montbold",
    marginTop: 5,
  },
  statLabel: {
    color: Colors.secondary,
    fontSize: 12,
    fontFamily: "montregular",
    marginTop: 2,
  },
  packageInfoContainer: {
    backgroundColor: Colors.white,
    borderRadius: 15,
    padding: 15,
    marginVertical: 15,
    boxShadow: Colors.tertiary,
    shadowOffset: { width: 0, height: 2 },
    shadowOpacity: 0.1,
    shadowRadius: 4,
    elevation: 3,
  },
  packageTitle: {
    fontSize: 16,
    fontFamily: "montbold",
    color: Colors.primary,
    marginBottom: 5,
  },
  packageExpiry: {
    fontSize: 14,
    fontFamily: "montregular",
    color: Colors.secondary,
    marginBottom: 10,
  },
  upgradeButton: {
    flexDirection: "row",
    alignItems: "center",
    justifyContent: "center",
    backgroundColor: Colors.primary,
    padding: 10,
    borderRadius: 8,
    marginTop: 5,
  },
  upgradeButtonText: {
    color: Colors.white,
    fontFamily: "montmedium",
    marginLeft: 8,
  },
  quickActionsContainer: {
    flexDirection: "row",
    flexWrap: "wrap",
    gap: 10,
    marginBottom: 20,
  },
  actionItem: {
    width: "48%",
    backgroundColor: Colors.white,
    padding: 15,
    borderRadius: 12,
    alignItems: "center",
    boxShadow: Colors.tertiary,
    shadowOffset: { width: 0, height: 2 },
    shadowOpacity: 0.1,
    shadowRadius: 4,
    elevation: 3,
  },
  actionText: {
    color: Colors.primary,
    fontSize: 14,
    fontFamily: "montmedium",
    marginTop: 8,
  },
  settingsContainer: {
    backgroundColor: Colors.white,
    borderRadius: 15,
    overflow: "hidden",
    boxShadow: Colors.tertiary,
    shadowOffset: { width: 0, height: 2 },
    shadowOpacity: 0.1,
    shadowRadius: 4,
    elevation: 3,
  },
  settingsItem: {
    flexDirection: "row",
    alignItems: "center",
    padding: 15,
    borderBottomWidth: 1,
    borderBottomColor: Colors.tertiary + "20",
  },
  settingsText: {
    flex: 1,
    color: Colors.primary,
    fontSize: 16,
    fontFamily: "montmedium",
    marginLeft: 15,
  },

  profilePageHeaderContainer: {
    alignItems: "center",
    marginBottom: 20,
  },
  profilePageStatsContainer: {
    flexDirection: "row",
    justifyContent: "space-around",
    backgroundColor: Colors.white,
    borderRadius: 15,
    padding: 15,
    marginBottom: 15,
    boxShadow: Colors.tertiary,
    shadowOffset: { width: 0, height: 2 },
    shadowOpacity: 0.1,
    shadowRadius: 4,
    elevation: 3,
  },
  DoctorProfilePageAvatar: {
    width: 100,
    height: 100,
    borderRadius: 50,
    marginBottom: 10,
  },
  profilePageName: {
    fontSize: 24,
    fontFamily: "montbold",
    color: Colors.primary,
    textAlign: "center",
  },

  settingsItem: {
    flexDirection: "row",
    alignItems: "center",
    padding: 15,
    borderBottomWidth: 1,
    borderBottomColor: Colors.tertiary + "20",
  },

  editProfileContainer: {
    padding: 15,
    backgroundColor: Colors.white,
  },
  avatarContainer: {
    alignItems: "center",
    marginVertical: 20,
    position: "relative",
  },
  profileAvatar: {
    width: 120,
    height: 120,
    borderRadius: 60,
    borderWidth: 3,
    borderColor: Colors.primary,
  },
  editAvatarButton: {
    position: "absolute",
    bottom: 0,
    right: "35%",
    backgroundColor: Colors.primary,
    width: 36,
    height: 36,
    borderRadius: 18,
    justifyContent: "center",
    alignItems: "center",
    borderWidth: 3,
    borderColor: Colors.white,
  },
  inputSection: {
    marginBottom: 20,
    backgroundColor: Colors.white,
    borderRadius: 10,
    padding: 15,
    boxShadow: Colors.tertiary,
    shadowOffset: { width: 0, height: 2 },
    shadowOpacity: 0.1,
    shadowRadius: 4,
    elevation: 3,
  },
  inputLabel: {
    fontSize: 16,
    fontFamily: "montbold",
    color: Colors.primary,
    marginBottom: 15,
  },
  inputDietitianProfileEdit: {
    backgroundColor: Colors.tertiary + "10",
    borderRadius: 8,
    padding: 12,
    marginBottom: 15,
    fontSize: 14,
    fontFamily: "montregular",
    color: Colors.secondary,
  },
  textArea: {
    height: 100,
    textAlignVertical: "top",
  },
  saveButton: {
    flexDirection: "row",
    alignItems: "center",
    justifyContent: "center",
    backgroundColor: Colors.primary,
    padding: 15,
    borderRadius: 10,
    marginVertical: 20,
    marginTop: 30,
  },
  saveButtonText: {
    color: Colors.white,
    fontSize: 16,
    fontFamily: "montbold",
    marginLeft: 10,
  },
  specializationContainer: {
    flexDirection: "row",
    flexWrap: "wrap",
    gap: 10,
    marginBottom: 12,
  },
  specializationTag: {
    flexDirection: "row",
    alignItems: "center",
    backgroundColor: Colors.primary + "20",
    paddingVertical: 8,
    paddingHorizontal: 12,
    borderRadius: 20,
  },
  specializationText: {
    color: Colors.primary,
    fontSize: 14,
    fontFamily: "montmedium",
    marginRight: 5,
  },
  removeSpecializationButton: {
    padding: 2,
  },
  addSpecializationButton: {
    flexDirection: "row",
    alignItems: "center",
    backgroundColor: Colors.white,
    borderWidth: 1,
    borderColor: Colors.primary,
    borderStyle: "dashed",
    paddingVertical: 8,
    paddingHorizontal: 12,
    borderRadius: 20,
  },
  addSpecializationText: {
    color: Colors.primary,
    fontSize: 14,
    fontFamily: "montmedium",
    marginLeft: 5,
  },
  certificateContainer: {
    marginBottom: 12,
  },
  certificateItem: {
    flexDirection: "row",
    alignItems: "center",
    justifyContent: "space-between",
    backgroundColor: Colors.tertiary + "10",
    padding: 12,
    borderRadius: 8,
    marginBottom: 8,
  },
  certificateText: {
    flex: 1,
    fontSize: 14,
    fontFamily: "montregular",
    color: Colors.secondary,
  },
  removeCertificateButton: {
    padding: 5,
  },
  addCertificateButton: {
    flexDirection: "row",
    alignItems: "center",
    justifyContent: "center",
    backgroundColor: Colors.white,
    borderWidth: 1,
    borderColor: Colors.primary,
    borderStyle: "dashed",
    padding: 12,
    borderRadius: 8,
  },
  addCertificateText: {
    color: Colors.primary,
    fontSize: 14,
    fontFamily: "montmedium",
    marginLeft: 5,
  },
  errorText: {
    color: Colors.danger,
    fontSize: 12,
    fontFamily: "montregular",
    marginTop: -8,
    marginBottom: 12,
    marginLeft: 4,
  },
  inputIcon: {
    position: "absolute",
    right: 12,
    top: 12,
  },
  inputWithIcon: {
    paddingRight: 40,
  },
  divider: {
    height: 1,
    backgroundColor: Colors.tertiary + "20",
    marginVertical: 15,
  },

  workingHoursContainer: {
    padding: 15,
    backgroundColor: Colors.white,
  },
  timeSelectionContainer: {
    backgroundColor: Colors.white,
    borderRadius: 15,
    padding: 15,
    marginTop: 20,
    boxShadow: Colors.tertiary,
    shadowOffset: { width: 0, height: 2 },
    shadowOpacity: 0.1,
    shadowRadius: 4,
    elevation: 3,
  },
  selectedDateText: {
    fontSize: 16,
    fontFamily: "montbold",
    color: Colors.primary,
    marginBottom: 15,
    textAlign: "center",
  },
  timeButtonsContainer: {
    flexDirection: "row",
    justifyContent: "space-between",
    gap: 10,
  },
  timeButton: {
    flex: 1,
    flexDirection: "row",
    alignItems: "center",
    justifyContent: "center",
    backgroundColor: Colors.white,
    borderWidth: 1,
    borderColor: Colors.primary,
    borderRadius: 10,
    padding: 12,
    gap: 8,
  },
  timeButtonDisabled: {
    borderColor: Colors.tertiary,
    opacity: 0.6,
  },
  timeButtonText: {
    color: Colors.secondary,
    fontSize: 14,
    fontFamily: "montmedium",
  },
  workingHoursLegend: {
    flexDirection: "row",
    justifyContent: "center",
    alignItems: "center",
    gap: 15,
    marginTop: 15,
    padding: 10,
    backgroundColor: Colors.tertiary + "10",
    borderRadius: 8,
  },

  workingHoursHeader: {
    flexDirection: "row",
    justifyContent: "space-between",
    alignItems: "center",
    marginBottom: 15,
  },
  workingHoursTitle: {
    fontSize: 18,
    fontFamily: "montbold",
    color: Colors.primary,
  },
  workingHoursSubtext: {
    fontSize: 12,
    fontFamily: "montregular",
    color: Colors.secondary,
    marginTop: 5,
  },

  workingHoursSummaryContainer: {
    backgroundColor: Colors.white,
    borderRadius: 15,
    padding: 15,
    marginTop: 15,
    boxShadow: Colors.tertiary,
    shadowOffset: { width: 0, height: 2 },
    shadowOpacity: 0.1,
    shadowRadius: 4,
    elevation: 3,
    marginBottom: 30,
  },
  sectionHeader: {
    flexDirection: "row",
    justifyContent: "space-between",
    alignItems: "center",
    marginBottom: 10,
  },
  WorkingSectionTitle: {
    fontSize: 16,
    fontFamily: "montbold",
    color: Colors.primary,
  },
  sectionButton: {
    padding: 5,
  },
  workingHoursText: {
    fontSize: 14,
    fontFamily: "montmedium",
    color: Colors.secondary,
    marginBottom: 5,
  },
  workingDaysText: {
    fontSize: 14,
    fontFamily: "montmedium",
    color: Colors.secondary,
  },

  sendRequestContainer: {
    padding: 15,
    backgroundColor: Colors.white,
  },
  appointmentSection: {
    backgroundColor: Colors.white,
    borderRadius: 15,
    padding: 15,
    marginTop: 20,
    boxShadow: Colors.tertiary,
    shadowOffset: { width: 0, height: 2 },
    shadowOpacity: 0.1,
    shadowRadius: 4,
    elevation: 3,
  },
  sectionTitle: {
    fontSize: 16,
    fontFamily: "montbold",
    color: Colors.primary,
    marginBottom: 15,
  },
  datePickerButton: {
    flexDirection: "row",
    alignItems: "center",
    backgroundColor: Colors.tertiary + "10",
    borderRadius: 8,
    padding: 12,
    marginBottom: 12,
    borderWidth: 1,
    borderColor: Colors.primary,
  },
  datePickerButtonDisabled: {
    borderColor: Colors.tertiary,
    opacity: 0.6,
  },
  datePickerButtonText: {
    marginLeft: 10,
    color: Colors.secondary,
    fontSize: 14,
    fontFamily: "montmedium",
  },
  textArea: {
    height: 100,
    textAlignVertical: "top",
    paddingTop: 12,
  },
  sendRequestButton: {
    flexDirection: "row",
    alignItems: "center",
    justifyContent: "center",
    backgroundColor: Colors.primary,
    padding: 15,
    borderRadius: 10,
    marginTop: 20,
    gap: 10,
  },
  sendRequestButtonText: {
    color: Colors.white,
    fontSize: 16,
    fontFamily: "montbold",
  },
  availabilityInfo: {
    backgroundColor: Colors.tertiary + "10",
    borderRadius: 8,
    padding: 12,
    marginTop: 10,
    marginBottom: 15,
  },
  availabilityInfoText: {
    color: Colors.secondary,
    fontSize: 12,
    fontFamily: "montmedium",
    textAlign: "center",
  },
  timeSlotContainer: {
    flexDirection: "row",
    flexWrap: "wrap",
    gap: 10,
    marginTop: 10,
  },
  timeSlot: {
    paddingVertical: 8,
    paddingHorizontal: 12,
    borderRadius: 20,
    borderWidth: 1,
    borderColor: Colors.primary,
    backgroundColor: Colors.white,
  },
  timeSlotSelected: {
    backgroundColor: Colors.primary,
  },
  timeSlotText: {
    color: Colors.primary,
    fontSize: 14,
    fontFamily: "montmedium",
  },
  timeSlotTextSelected: {
    color: Colors.white,
  },
  timeSlotDisabled: {
    borderColor: Colors.tertiary,
    backgroundColor: Colors.tertiary + "10",
  },
  timeSlotTextDisabled: {
    color: Colors.tertiary,
  },
  serviceTypeContainer: {
    marginBottom: 15,
  },
  serviceTypeButton: {
    flexDirection: "row",
    alignItems: "center",
    padding: 15,
    borderRadius: 10,
    borderWidth: 1,
    borderColor: Colors.tertiary,
    marginBottom: 10,
  },
  serviceTypeButtonSelected: {
    borderColor: Colors.primary,
    backgroundColor: Colors.primary + "10",
  },
  serviceTypeText: {
    marginLeft: 10,
    fontSize: 14,
    fontFamily: "montmedium",
    color: Colors.secondary,
  },
  serviceTypeTextSelected: {
    color: Colors.primary,
  },
  priceInfo: {
    flexDirection: "row",
    justifyContent: "space-between",
    alignItems: "center",
    backgroundColor: Colors.white,
    borderRadius: 10,
    padding: 15,
    marginTop: 15,
    borderWidth: 1,
    borderColor: Colors.primary + "30",
  },
  priceLabel: {
    fontSize: 14,
    fontFamily: "montmedium",
    color: Colors.secondary,
  },
  priceValue: {
    fontSize: 16,
    fontFamily: "montbold",
    color: Colors.primary,
  },

  sendRequestContainer: {
    padding: 15,
    backgroundColor: Colors.white,
  },
  calendarSection: {
    backgroundColor: Colors.white,
    borderRadius: 15,
    padding: 15,
    marginTop: 20,
    boxShadow: Colors.tertiary,
    shadowOffset: { width: 0, height: 2 },
    shadowOpacity: 0.1,
    shadowRadius: 4,
    elevation: 3,
  },
  timeSlotsContainer: {
    marginTop: 20,
    backgroundColor: Colors.tertiary + "10",
    borderRadius: 10,
    padding: 15,
  },
  selectedDateText: {
    fontSize: 16,
    fontFamily: "montbold",
    color: Colors.primary,
    textAlign: "center",
    marginBottom: 15,
  },
  timeSlotGrid: {
    flexDirection: "row",
    flexWrap: "wrap",
    justifyContent: "center",
    gap: 10,
  },
  timeSlot: {
    width: "30%",
    paddingVertical: 10,
    paddingHorizontal: 5,
    borderRadius: 8,
    backgroundColor: Colors.white,
    borderWidth: 1,
    borderColor: Colors.primary,
    alignItems: "center",
    justifyContent: "center",
  },
  timeSlotSelected: {
    backgroundColor: Colors.primary,
    borderColor: Colors.primary,
  },
  timeSlotBooked: {
    backgroundColor: Colors.danger + "20",
    borderColor: Colors.danger,
  },
  timeSlotText: {
    fontSize: 14,
    fontFamily: "montmedium",
    color: Colors.primary,
  },
  timeSlotTextSelected: {
    color: Colors.white,
  },
  timeSlotTextBooked: {
    color: Colors.danger,
  },
  formSection: {
    marginTop: 20,
    gap: 15,
  },
  calendarLegend: {
    flexDirection: "row",
    justifyContent: "center",
    alignItems: "center",
    gap: 15,
    marginTop: 15,
    paddingVertical: 10,
    backgroundColor: Colors.white,
    borderRadius: 8,
    borderWidth: 1,
    borderColor: Colors.tertiary + "30",
  },
  legendItem: {
    flexDirection: "row",
    alignItems: "center",
    gap: 5,
  },
  legendDot: {
    width: 8,
    height: 8,
    borderRadius: 4,
  },
  legendText: {
    fontSize: 12,
    fontFamily: "montregular",
    color: Colors.secondary,
  },
  input: {
    backgroundColor: Colors.tertiary + "10",
    borderRadius: 8,
    padding: 12,
    fontSize: 14,
    fontFamily: "montregular",
    color: Colors.secondary,
  },
  textArea: {
    height: 100,
    textAlignVertical: "top",
  },
  sendRequestButton: {
    flexDirection: "row",
    alignItems: "center",
    justifyContent: "center",
    backgroundColor: Colors.primary,
    padding: 15,
    borderRadius: 10,
    marginTop: 10,
    gap: 10,
    marginBottom: 20,
  },
  sendRequestButtonText: {
    color: Colors.white,
    fontSize: 16,
    fontFamily: "montbold",
  },
  timeSlotHeader: {
    flexDirection: "row",
    justifyContent: "space-between",
    alignItems: "center",
    marginBottom: 10,
  },
  timeSlotTitle: {
    fontSize: 14,
    fontFamily: "montbold",
    color: Colors.secondary,
  },
  availabilityIndicator: {
    flexDirection: "row",
    alignItems: "center",
    gap: 5,
    paddingHorizontal: 10,
    paddingVertical: 5,
    borderRadius: 15,
    backgroundColor: Colors.success + "20",
  },
  availabilityIndicatorText: {
    fontSize: 12,
    fontFamily: "montmedium",
    color: Colors.success,
  },
  noSlotsAvailable: {
    padding: 20,
    alignItems: "center",
  },
  noSlotsText: {
    fontSize: 14,
    fontFamily: "montmedium",
    color: Colors.tertiary,
    textAlign: "center",
  },
  calendarContainer: {
    borderRadius: 10,
    overflow: "hidden",
    borderWidth: 1,
    borderColor: Colors.tertiary + "30",
  },
  timeSlotDivider: {
    height: 1,
    backgroundColor: Colors.tertiary + "30",
    marginVertical: 15,
  },
  serviceTypeContainer: {
    marginBottom: 15,
  },
  notesContainer: {
    marginBottom: 20,
  },

  heightPickerContainer: {
    flexDirection: "row",
    justifyContent: "center",
    alignItems: "center",
    height: 250,
    marginTop: 20,
    paddingHorizontal: 20,
  },
  humanIcon: {
    width: 120,
    height: 200,
    justifyContent: "center",
    alignItems: "center",
  },
  sliderContainer: {
    height: 200,
    marginHorizontal: 20,
    justifyContent: "center",
  },
  rulerContainer: {
    height: 250,
    justifyContent: "space-between",
    position: "absolute",
    right: 0,
  },
  rulerMark: {
    flexDirection: "row",
    alignItems: "center",
    height: 20,
  },
  rulerLine: {
    width: 15,
    height: 1,
    backgroundColor: Colors.secondary,
    marginRight: 5,
  },
  rulerText: {
    fontSize: 12,
    color: Colors.secondary,
    fontFamily: "montregular",
  },
  selectedHeightContainer: {
    alignItems: "center",
    marginTop: 20,
  },
  selectedHeight: {
    fontSize: 24,
    color: Colors.primary,
    fontFamily: "montbold",
  },

  bigDot: {
    width: 40,
    height: 40,
    borderRadius: 100,
    alignItems: "center",
    justifyContent: "center",
  },

  registerChecboxDisease: {
    width: 24,
    height: 24,
    borderColor: Colors.secondary,
  },

  diseaseCheckboxContainer: {
    flexDirection: "row",
    alignItems: "center",
    paddingVertical: 12,
    paddingHorizontal: 5,
    borderBottomWidth: 1,
    borderBottomColor: Colors.secondary + "80",
  },
  customCheckbox: {
    width: 24,
    height: 24,
    borderWidth: 2,
    borderColor: Colors.secondary,
    borderRadius: 6,
    marginRight: 12,
    justifyContent: "center",
    alignItems: "center",
    backgroundColor: Colors.white,
  },
  customCheckboxChecked: {
    backgroundColor: Colors.primary,
    borderColor: Colors.primary,
  },
  diseaseCheckboxLabel: {
    fontSize: 16,
    color: Colors.tertiary,
    fontFamily: "montmedium",
  },

  appointmentDetailContainer: {
    padding: 15,
    backgroundColor: Colors.white,
  },
  appointmentHeader: {
    flexDirection: "row",
    justifyContent: "space-between",
    alignItems: "center",
    backgroundColor: Colors.white,
    borderRadius: 15,
    padding: 15,
    marginBottom: 15,
    boxShadow: Colors.tertiary,
    shadowOffset: { width: 0, height: 2 },
    shadowOpacity: 0.1,
    shadowRadius: 4,
    elevation: 3,
  },
  appointmentClientInfo: {
    flex: 1,
  },
  appointmentClientName: {
    fontSize: 18,
    fontFamily: "montbold",
    color: Colors.primary,
    marginBottom: 5,
  },
  appointmentType: {
    fontSize: 14,
    fontFamily: "montmedium",
    color: Colors.secondary,
  },
  appointmentStatus: {
    flexDirection: "row",
    alignItems: "center",
    paddingHorizontal: 12,
    paddingVertical: 6,
    borderRadius: 20,
    gap: 5,
  },
  appointmentStatusText: {
    fontSize: 12,
    fontFamily: "montmedium",
  },
  appointmentInfo: {
    backgroundColor: Colors.white,
    borderRadius: 15,
    padding: 15,
    marginBottom: 15,
    boxShadow: Colors.tertiary,
    shadowOffset: { width: 0, height: 2 },
    shadowOpacity: 0.1,
    shadowRadius: 4,
    elevation: 3,
  },
  appointmentInfoRow: {
    flexDirection: "row",
    alignItems: "center",
    gap: 10,
  },
  appointmentInfoText: {
    fontSize: 14,
    fontFamily: "montmedium",
    color: Colors.secondary,
  },
  appointmentClientSection: {
    backgroundColor: Colors.white,
    borderRadius: 15,
    padding: 15,
    marginBottom: 15,
    boxShadow: Colors.tertiary,
    shadowOffset: { width: 0, height: 2 },
    shadowOpacity: 0.1,
    shadowRadius: 4,
    elevation: 3,
  },
  appointmentDetailGrid: {
    flexDirection: "row",
    flexWrap: "wrap",
    gap: 15,
    marginTop: 10,
  },
  appointmentDetailItem: {
    width: "45%",
    backgroundColor: Colors.tertiary + "10",
    borderRadius: 10,
    padding: 12,
  },
  appointmentDetailLabel: {
    fontSize: 12,
    fontFamily: "montmedium",
    color: Colors.secondary,
    marginBottom: 5,
  },
  appointmentDetailValue: {
    fontSize: 14,
    fontFamily: "montbold",
    color: Colors.primary,
  },
  appointmentNotesSection: {
    backgroundColor: Colors.white,
    borderRadius: 15,
    padding: 15,
    marginBottom: 15,
    boxShadow: Colors.tertiary,
    shadowOffset: { width: 0, height: 2 },
    shadowOpacity: 0.1,
    shadowRadius: 4,
    elevation: 3,
  },
  appointmentNotesText: {
    fontSize: 14,
    fontFamily: "montregular",
    color: Colors.secondary,
    lineHeight: 20,
  },
  appointmentActionButtons: {
    flexDirection: "row",
    gap: 10,
    marginTop: 5,
  },
  appointmentConfirmButton: {
    flex: 1,
    flexDirection: "row",
    alignItems: "center",
    justifyContent: "center",
    backgroundColor: Colors.primary,
    padding: 15,
    borderRadius: 10,
    gap: 10,
  },
  appointmentCancelButton: {
    flex: 1,
    flexDirection: "row",
    alignItems: "center",
    justifyContent: "center",
    backgroundColor: Colors.white,
    padding: 15,
    borderRadius: 10,
    borderWidth: 1,
    borderColor: Colors.danger,
    gap: 10,
  },
  appointmentButtonText: {
    fontSize: 14,
    fontFamily: "montbold",
    color: Colors.white,
  },

  blogSearchContainer: {
    flexDirection: "row",
    alignItems: "center",
    backgroundColor: Colors.white,
    borderRadius: 10,
    padding: 12,
    margin: 15,
    boxShadow: Colors.tertiary,
    shadowOffset: { width: 0, height: 2 },
    shadowOpacity: 0.1,
    shadowRadius: 4,
    elevation: 3,
  },
  blogSearchInput: {
    flex: 1,
    marginLeft: 10,
    fontSize: 14,
    fontFamily: "montregular",
    color: Colors.secondary,
  },
  createBlogButton: {
    flexDirection: "row",
    alignItems: "center",
    justifyContent: "center",
    backgroundColor: Colors.primary,
    padding: 15,
    marginHorizontal: 15,
    borderRadius: 10,
    gap: 10,
  },
  createBlogButtonText: {
    color: Colors.white,
    fontSize: 16,
    fontFamily: "montbold",
  },
  blogListContainer: {
    padding: 15,
  },
  blogCard: {
    backgroundColor: Colors.white,
    borderRadius: 15,
    marginBottom: 15,
    boxShadow: Colors.tertiary,
    shadowOffset: { width: 0, height: 2 },
    shadowOpacity: 0.1,
    shadowRadius: 4,
    elevation: 3,
    overflow: "hidden",
  },
  blogImage: {
    width: "100%",
    height: 200,
  },
  blogContent: {
    padding: 15,
  },
  blogHeader: {
    flexDirection: "row",
    justifyContent: "space-between",
    alignItems: "center",
    marginBottom: 10,
  },
  blogTitle: {
    flex: 1,
    fontSize: 16,
    fontFamily: "montbold",
    color: Colors.primary,
    marginRight: 10,
  },
  blogStatus: {
    paddingHorizontal: 10,
    paddingVertical: 5,
    borderRadius: 15,
  },
  blogStatusText: {
    fontSize: 12,
    fontFamily: "montmedium",
  },
  blogPreview: {
    fontSize: 14,
    fontFamily: "montregular",
    color: Colors.secondary,
    marginBottom: 15,
    lineHeight: 20,
  },
  blogStats: {
    flexDirection: "row",
    justifyContent: "space-between",
    borderTopWidth: 1,
    borderTopColor: Colors.tertiary + "20",
    paddingTop: 15,
  },
  blogStatItem: {
    flexDirection: "row",
    alignItems: "center",
    gap: 5,
  },
  blogStatText: {
    fontSize: 12,
    fontFamily: "montmedium",
    color: Colors.secondary,
  },

  reviewStats: {
    flexDirection: "row",
    backgroundColor: Colors.white,
    borderRadius: 15,
    margin: 15,
    padding: 20,
    boxShadow: Colors.tertiary,
    shadowOffset: { width: 0, height: 2 },
    shadowOpacity: 0.1,
    shadowRadius: 4,
    elevation: 3,
  },
  reviewStatItem: {
    flex: 1,
    alignItems: "center",
  },
  reviewStatNumber: {
    fontSize: 24,
    fontFamily: "montbold",
    color: Colors.primary,
    marginBottom: 5,
  },
  reviewStatLabel: {
    fontSize: 12,
    fontFamily: "montmedium",
    color: Colors.secondary,
    marginTop: 5,
  },
  reviewStatDivider: {
    width: 1,
    backgroundColor: Colors.tertiary + "30",
    marginHorizontal: 15,
  },
  reviewListContainer: {
    padding: 15,
  },
  reviewCard: {
    backgroundColor: Colors.white,
    borderRadius: 15,
    padding: 15,
    marginBottom: 15,
    boxShadow: Colors.tertiary,
    shadowOffset: { width: 0, height: 2 },
    shadowOpacity: 0.1,
    shadowRadius: 4,
    elevation: 3,
  },
  reviewHeader: {
    flexDirection: "row",
    justifyContent: "space-between",
    marginBottom: 15,
  },
  reviewClientInfo: {
    flexDirection: "row",
    alignItems: "center",
  },
  reviewClientAvatar: {
    width: 40,
    height: 40,
    borderRadius: 20,
    marginRight: 10,
  },
  reviewClientName: {
    fontSize: 14,
    fontFamily: "montbold",
    color: Colors.primary,
  },
  reviewProgramType: {
    fontSize: 12,
    fontFamily: "montmedium",
    color: Colors.secondary,
  },
  reviewRating: {
    alignItems: "flex-end",
  },
  starsContainer: {
    flexDirection: "row",
    gap: 2,
  },
  reviewDate: {
    fontSize: 12,
    fontFamily: "montregular",
    color: Colors.secondary,
    marginTop: 5,
  },
  reviewComment: {
    fontSize: 14,
    fontFamily: "montregular",
    color: Colors.secondary,
    lineHeight: 20,
    marginBottom: 15,
  },
  reviewResponse: {
    backgroundColor: Colors.tertiary + "10",
    borderRadius: 10,
    padding: 12,
  },
  responseLabel: {
    fontSize: 12,
    fontFamily: "montbold",
    color: Colors.primary,
    marginBottom: 5,
  },
  responseText: {
    fontSize: 14,
    fontFamily: "montregular",
    color: Colors.secondary,
  },
  replyButton: {
    flexDirection: "row",
    alignItems: "center",
    justifyContent: "center",
    padding: 12,
    borderRadius: 10,
    borderWidth: 1,
    borderColor: Colors.primary,
    marginTop: 15,
    gap: 8,
  },
  replyButtonText: {
    fontSize: 14,
    fontFamily: "montbold",
    color: Colors.primary,
  },

  clientDetailContainer: {
    padding: 15,
    backgroundColor: Colors.white,
  },
  clientDetailHeader: {
    alignItems: "center",
    padding: 20,
    backgroundColor: Colors.white,
    borderRadius: 15,
    marginBottom: 15,
    boxShadow: Colors.tertiary,
    shadowOffset: { width: 0, height: 2 },
    shadowOpacity: 0.1,
    shadowRadius: 4,
    elevation: 3,
  },
  clientDetailAvatar: {
    width: 100,
    height: 100,
    borderRadius: 50,
    marginBottom: 15,
  },
  clientDetailName: {
    fontSize: 20,
    fontFamily: "montbold",
    color: Colors.primary,
    marginBottom: 5,
  },
  clientDetailProgram: {
    fontSize: 14,
    fontFamily: "montmedium",
    color: Colors.secondary,
    marginBottom: 15,
  },
  clientDetailProgress: {
    width: "100%",
    alignItems: "center",
  },
  progressPercentage: {
    fontSize: 24,
    fontFamily: "montbold",
    color: Colors.primary,
    marginBottom: 5,
  },
  progressBarContainer: {
    width: "100%",
    height: 8,
    backgroundColor: Colors.tertiary + "20",
    borderRadius: 4,
    marginBottom: 5,
  },
  progressBarFill: {
    height: "100%",
    backgroundColor: Colors.primary,
    borderRadius: 4,
  },
  progressLabel: {
    fontSize: 12,
    fontFamily: "montmedium",
    color: Colors.secondary,
  },
  clientDetailSection: {
    backgroundColor: Colors.white,
    borderRadius: 15,
    padding: 15,
    marginBottom: 15,
    boxShadow: Colors.tertiary,
    shadowOffset: { width: 0, height: 2 },
    shadowOpacity: 0.1,
    shadowRadius: 4,
    elevation: 3,
  },
  programInfoGrid: {
    flexDirection: "row",
    flexWrap: "wrap",
    gap: 15,
  },
  infoItem: {
    width: "45%",
    alignItems: "center",
    padding: 15,
    backgroundColor: Colors.tertiary + "10",
    borderRadius: 10,
  },
  infoLabel: {
    fontSize: 12,
    fontFamily: "montmedium",
    color: Colors.secondary,
    marginTop: 5,
  },
  infoValue: {
    fontSize: 14,
    fontFamily: "montbold",
    color: Colors.primary,
    marginTop: 5,
  },
  measurementsGrid: {
    flexDirection: "row",
    flexWrap: "wrap",
    gap: 10,
  },
  measurementItem: {
    width: "30%",
    alignItems: "center",
    padding: 10,
    backgroundColor: Colors.tertiary + "10",
    borderRadius: 10,
  },
  measurementLabel: {
    fontSize: 12,
    fontFamily: "montmedium",
    color: Colors.secondary,
    marginBottom: 5,
    textAlign: "center",
  },
  measurementValue: {
    fontSize: 14,
    fontFamily: "montbold",
    color: Colors.primary,
  },
  historyItem: {
    borderBottomWidth: 1,
    borderBottomColor: Colors.tertiary + "20",
    paddingVertical: 15,
  },
  historyHeader: {
    flexDirection: "row",
    justifyContent: "space-between",
    marginBottom: 5,
  },
  historyDate: {
    fontSize: 14,
    fontFamily: "montbold",
    color: Colors.primary,
  },
  historyWeight: {
    fontSize: 14,
    fontFamily: "montbold",
    color: Colors.success,
  },
  historyNotes: {
    fontSize: 14,
    fontFamily: "montregular",
    color: Colors.secondary,
  },
  clientDetailActions: {
    flexDirection: "row",
    justifyContent: "space-between",
    gap: 10,
    marginTop: 5,
  },
  detailActionButton: {
    flex: 1,
    flexDirection: "row",
    alignItems: "center",
    justifyContent: "center",
    backgroundColor: Colors.primary,
    padding: 15,
    borderRadius: 10,
    gap: 8,
  },

  commentButton: {
    flexDirection: "row",
    alignItems: "center",
    justifyContent: "center",
    backgroundColor: Colors.white,
    padding: 15,
    borderRadius: 10,
    marginBottom: 15,
    borderWidth: 1,
    borderColor: Colors.primary,
    gap: 10,
  },
  commentButtonText: {
    fontSize: 16,
    fontFamily: "montbold",
    color: Colors.primary,
  },

  commentContainer: {
    padding: 15,
    backgroundColor: Colors.white,
  },
  ratingContainer: {
    alignItems: "center",
    backgroundColor: Colors.white,
    borderRadius: 15,
    padding: 20,
    marginBottom: 15,
    boxShadow: Colors.tertiary,
    shadowOffset: { width: 0, height: 2 },
    shadowOpacity: 0.1,
    shadowRadius: 4,
    elevation: 3,
  },
  ratingLabel: {
    fontSize: 16,
    fontFamily: "montbold",
    color: Colors.primary,
    marginBottom: 15,
  },
  starsContainer: {
    flexDirection: "row",
    alignItems: "center",
  },
  commentInputContainer: {
    backgroundColor: Colors.white,
    borderRadius: 15,
    padding: 15,
    marginBottom: 15,
    boxShadow: Colors.tertiary,
    shadowOffset: { width: 0, height: 2 },
    shadowOpacity: 0.1,
    shadowRadius: 4,
    elevation: 3,
  },
  commentLabel: {
    fontSize: 16,
    fontFamily: "montbold",
    color: Colors.primary,
    marginBottom: 10,
  },
  commentInput: {
    backgroundColor: Colors.tertiary + "10",
    borderRadius: 10,
    padding: 15,
    fontSize: 14,
    fontFamily: "montregular",
    color: Colors.secondary,
    minHeight: 120,
  },
  submitCommentButton: {
    flexDirection: "row",
    alignItems: "center",
    justifyContent: "center",
    backgroundColor: Colors.primary,
    padding: 15,
    borderRadius: 10,
    gap: 10,
  },
  submitCommentButtonText: {
    fontSize: 16,
    fontFamily: "montbold",
    color: Colors.white,
  },

  productListContainer: {
    padding: 15,
  },
  addProductButton: {
    flexDirection: "row",
    alignItems: "center",
    justifyContent: "center",
    backgroundColor: Colors.primary,
    padding: 15,
    margin: 15,
    borderRadius: 10,
    gap: 10,
  },
  addProductButtonText: {
    fontSize: 16,
    fontFamily: "montbold",
    color: Colors.white,
  },
  productCard: {
    backgroundColor: Colors.white,
    borderRadius: 15,
    marginBottom: 15,
    boxShadow: Colors.tertiary,
    shadowOffset: { width: 0, height: 2 },
    shadowOpacity: 0.1,
    shadowRadius: 4,
    elevation: 3,
    overflow: "hidden",
  },
  productImage: {
    width: "100%",
    height: 150,
    resizeMode: "cover",
  },
  productInfo: {
    padding: 10,
    flexDirection: "row",
    justifyContent: "space-between",
    alignItems: "center",
    columnGap: 10,
  },
  productHeader: {
    flexDirection: "row",
    justifyContent: "space-between",
    alignItems: "center",
    marginBottom: 10,
  },
  productName: {
    fontSize: 16,
    fontFamily: "montbold",
    color: Colors.primary,
    marginRight: 10,
  },
  productStatus: {
    paddingHorizontal: 10,
    paddingVertical: 5,
    borderRadius: 15,
  },
  productStatusText: {
    fontSize: 12,
    fontFamily: "montmedium",
  },
  productPrice: {
    fontSize: 18,
    fontFamily: "montbold",
    color: Colors.success,
  },
  productStock: {
    fontSize: 14,
    fontFamily: "montmedium",
    color: Colors.secondary,
  },

  addProductContainer: {
    padding: 15,
    backgroundColor: Colors.white,
  },
  imagePickerButton: {
    width: "100%",
    height: 200,
    backgroundColor: Colors.tertiary + "10",
    borderRadius: 15,
    justifyContent: "center",
    alignItems: "center",
    marginBottom: 20,
    borderWidth: 2,
    borderColor: Colors.tertiary + "30",
    borderStyle: "dashed",
  },
  productPreviewImage: {
    width: "100%",
    height: "100%",
    borderRadius: 15,
    resizeMode: "cover",
  },
  imagePickerText: {
    marginTop: 10,
    fontSize: 14,
    fontFamily: "montmedium",
    color: Colors.primary,
  },
  inputContainer: {
    marginBottom: 15,
  },

  inputRow: {
    flexDirection: "row",
    gap: 10,
    marginBottom: 15,
  },

  submitProductButton: {
    flexDirection: "row",
    alignItems: "center",
    justifyContent: "center",
    backgroundColor: Colors.primary,
    padding: 15,
    borderRadius: 10,
    marginTop: 10,
    gap: 10,
  },
  submitProductButtonText: {
    fontSize: 16,
    fontFamily: "montbold",
    color: Colors.white,
  },

  marketSearchContainer: {
    flexDirection: "row",
    alignItems: "center",
    backgroundColor: Colors.white,
    borderRadius: 10,
    padding: 12,
    margin: 15,
    boxShadow: Colors.tertiary,
    shadowOffset: { width: 0, height: 2 },
    shadowOpacity: 0.1,
    shadowRadius: 4,
    elevation: 3,
  },
  marketSearchInput: {
    flex: 1,
    marginLeft: 10,
    fontSize: 14,
    fontFamily: "montregular",
    color: Colors.secondary,
  },
  marketCategoryContainer: {
    paddingHorizontal: 15,
  },
  marketCategoryButton: {
    paddingHorizontal: 20,
    paddingVertical: 10,
    borderRadius: 20,
    backgroundColor: Colors.tertiary + "10",
    marginRight: 10,
    height: 40,
  },
  marketCategoryButtonActive: {
    backgroundColor: Colors.primary,
  },
  marketCategoryText: {
    fontSize: 14,
    fontFamily: "montmedium",
    color: Colors.secondary,
  },
  marketCategoryTextActive: {
    color: Colors.white,
  },
  marketProductGrid: {
    padding: 15,
  },
  marketProductCard: {
    flex: 1,
    backgroundColor: Colors.white,
    borderRadius: 15,
    margin: 5,
    boxShadow: Colors.tertiary,
    shadowOffset: { width: 0, height: 2 },
    shadowOpacity: 0.1,
    shadowRadius: 4,
    elevation: 3,
    overflow: "hidden",
  },
  marketProductImage: {
    width: "100%",
    height: 150,
    resizeMode: "cover",
  },
  marketProductInfo: {
    padding: 10,
  },
  marketProductName: {
    fontSize: 14,
    fontFamily: "montbold",
    color: Colors.primary,
    marginBottom: 5,
  },
  marketProductPrice: {
    fontSize: 16,
    fontFamily: "montbold",
    color: Colors.success,
    marginBottom: 5,
  },
  marketProductRating: {
    flexDirection: "row",
    alignItems: "center",
    marginBottom: 5,
  },
  marketRatingStars: {
    flexDirection: "row",
    marginRight: 5,
  },
  marketReviewCount: {
    fontSize: 12,
    fontFamily: "montregular",
    color: Colors.secondary,
  },
  marketInStock: {
    fontSize: 12,
    fontFamily: "montbold",
    color: Colors.secondary,
    marginTop: 5,
  },
  marketOutOfStock: {
    fontSize: 12,
    fontFamily: "montbold",
    color: Colors.danger,
    marginTop: 5,
  },
  marketEmptyText: {
    textAlign: "center",
    fontSize: 14,
    fontFamily: "montmedium",
    color: Colors.secondary,
    marginTop: 20,
  },

  productDetailContainer: {
    flex: 1,
    backgroundColor: Colors.white,
  },
  productDetailImageContainer: {
    backgroundColor: Colors.white,
    padding: 15,
  },
  productDetailMainImage: {
    width: "100%",
    height: 300,
    resizeMode: "cover",
    borderRadius: 15,
  },
  productDetailThumbnails: {
    marginTop: 15,
  },
  productDetailThumbnail: {
    width: 60,
    height: 60,
    borderRadius: 10,
    marginRight: 10,
    borderWidth: 2,
    borderColor: Colors.tertiary + "30",
  },
  productDetailThumbnailActive: {
    borderColor: Colors.primary,
  },
  productDetailInfo: {
    padding: 15,
  },
  productDetailName: {
    fontSize: 20,
    fontFamily: "montbold",
    color: Colors.primary,
    marginBottom: 10,
  },
  productDetailPrice: {
    fontSize: 24,
    fontFamily: "montbold",
    color: Colors.success,
    marginBottom: 15,
  },
  productDetailRating: {
    flexDirection: "row",
    alignItems: "center",
    marginBottom: 20,
  },
  productDetailStars: {
    flexDirection: "row",
    marginRight: 10,
  },
  productDetailReviews: {
    fontSize: 14,
    fontFamily: "montregular",
    color: Colors.secondary,
  },
  productDetailFeatures: {
    marginBottom: 20,
  },
  productDetailFeatureItem: {
    flexDirection: "row",
    alignItems: "center",
    marginBottom: 8,
  },
  productDetailFeatureText: {
    marginLeft: 10,
    fontSize: 14,
    fontFamily: "montmedium",
    color: Colors.secondary,
  },
  productDetailSectionTitle: {
    fontSize: 16,
    fontFamily: "montbold",
    color: Colors.primary,
    marginBottom: 10,
  },
  productDetailDescription: {
    fontSize: 14,
    fontFamily: "montregular",
    color: Colors.secondary,
    lineHeight: 22,
    marginBottom: 20,
  },
  productDetailNutritionalInfo: {
    flexDirection: "row",
    flexWrap: "wrap",
    gap: 10,
    marginBottom: 20,
  },
  productDetailNutritionalItem: {
    backgroundColor: Colors.tertiary + "10",
    padding: 10,
    borderRadius: 10,
    width: "45%",
  },
  productDetailNutritionalLabel: {
    fontSize: 12,
    fontFamily: "montmedium",
    color: Colors.secondary,
    marginBottom: 5,
  },
  productDetailNutritionalValue: {
    fontSize: 14,
    fontFamily: "montbold",
    color: Colors.primary,
  },
  productDetailActionBar: {
    flexDirection: "row",
    padding: 15,
    backgroundColor: Colors.white,
    borderTopWidth: 1,
    borderTopColor: Colors.tertiary + "20",
  },
  productDetailQuantity: {
    flexDirection: "row",
    alignItems: "center",
    backgroundColor: Colors.tertiary + "10",
    borderRadius: 10,
    marginRight: 15,
    flex: 1,
    justifyContent: "center",
  },
  productDetailQuantityButton: {
    padding: 10,
  },
  productDetailQuantityText: {
    fontSize: 16,
    fontFamily: "montbold",
    color: Colors.primary,
    paddingHorizontal: 5,
  },
  productDetailAddToCart: {
    flex: 2,
    flexDirection: "row",
    alignItems: "center",
    justifyContent: "center",
    backgroundColor: Colors.primary,
    padding: 15,
    borderRadius: 10,
    gap: 10,
  },
  productDetailAddToCartText: {
    fontSize: 16,
    fontFamily: "montbold",
    color: Colors.white,
  },

  cartContainer: {
    flex: 1,
    padding: 15,
  },
  cartItemContainer: {
    flexDirection: "row",
    backgroundColor: Colors.white,
    borderRadius: 15,
    padding: 15,
    marginBottom: 15,
    boxShadow: Colors.tertiary,
    shadowOffset: { width: 0, height: 2 },
    shadowOpacity: 0.1,
    shadowRadius: 4,
    elevation: 3,
  },
  cartItemImage: {
    width: 80,
    height: 80,
    borderRadius: 10,
    marginRight: 15,
  },
  cartItemInfo: {
    flex: 1,
  },
  cartItemHeader: {
    flexDirection: "row",
    justifyContent: "space-between",
    alignItems: "flex-start",
  },
  cartItemName: {
    fontSize: 16,
    fontFamily: "montbold",
    color: Colors.primary,
    flex: 1,
    marginRight: 10,
  },
  cartItemRemove: {},
  cartItemDietitian: {
    fontSize: 14,
    fontFamily: "montmedium",
    color: Colors.secondary,
    marginBottom: 5,
  },
  cartItemPrice: {
    fontSize: 16,
    fontFamily: "montbold",
    color: Colors.secondary,
    marginBottom: 10,
  },
  cartItemActions: {
    flexDirection: "row",
    justifyContent: "space-between",
    alignItems: "center",
  },
  cartItemQuantity: {
    flexDirection: "row",
    alignItems: "center",
    backgroundColor: Colors.tertiary + "10",
    borderRadius: 8,
  },
  cartQuantityButton: {
    padding: 8,
  },
  cartQuantityText: {
    fontSize: 14,
    fontFamily: "montbold",
    color: Colors.primary,
    paddingHorizontal: 12,
  },
  cartItemTotal: {
    fontSize: 16,
    fontFamily: "montbold",
    color: Colors.primary,
  },
  cartSummary: {
    backgroundColor: Colors.white,
    borderRadius: 15,
    padding: 15,
    marginBottom: 15,
    boxShadow: Colors.tertiary,
    shadowOffset: { width: 0, height: 2 },
    shadowOpacity: 0.1,
    shadowRadius: 4,
    elevation: 3,
  },
  cartSummaryRow: {
    flexDirection: "row",
    justifyContent: "space-between",
    marginBottom: 10,
  },
  cartSummaryLabel: {
    fontSize: 14,
    fontFamily: "montmedium",
    color: Colors.secondary,
  },
  cartSummaryValue: {
    fontSize: 14,
    fontFamily: "montbold",
    color: Colors.secondary,
  },
  cartTotalRow: {
    borderTopWidth: 1,
    borderTopColor: Colors.tertiary + "20",
    paddingTop: 10,
    marginBottom: 0,
  },
  cartTotalLabel: {
    fontSize: 16,
    fontFamily: "montbold",
    color: Colors.primary,
  },
  cartTotalValue: {
    fontSize: 18,
    fontFamily: "montbold",
    color: Colors.primary,
  },
  checkoutButton: {
    flexDirection: "row",
    alignItems: "center",
    justifyContent: "center",
    backgroundColor: Colors.primary,
    padding: 15,
    borderRadius: 10,
    marginTop: 15,
    gap: 10,
  },
  checkoutButtonText: {
    fontSize: 16,
    fontFamily: "montbold",
    color: Colors.white,
  },
  emptyCartContainer: {
    flex: 1,
    alignItems: "center",
    justifyContent: "center",
    padding: 30,
  },
  emptyCartText: {
    fontSize: 18,
    fontFamily: "montbold",
    color: Colors.secondary,
    marginTop: 15,
    marginBottom: 20,
  },
  continueShopping: {
    padding: 15,
    borderRadius: 10,
    borderWidth: 1,
    borderColor: Colors.primary,
  },
  continueShoppingText: {
    fontSize: 14,
    fontFamily: "montbold",
    color: Colors.primary,
  },

  checkoutContainer: {
    flex: 1,
    padding: 15,
  },
  checkoutSection: {
    backgroundColor: Colors.white,
    borderRadius: 15,
    padding: 15,
    marginBottom: 15,
    boxShadow: Colors.tertiary,
    shadowOffset: { width: 0, height: 2 },
    shadowOpacity: 0.1,
    shadowRadius: 4,
    elevation: 3,
  },
  checkoutSectionHeader: {
    flexDirection: "row",
    alignItems: "center",
    marginBottom: 15,
    gap: 10,
  },
  checkoutSectionTitle: {
    fontSize: 18,
    fontFamily: "montbold",
    color: Colors.primary,
  },
  savedAddressesContainer: {
    marginBottom: 15,
  },
  /* savedAddressCard: {
        backgroundColor: Colors.tertiary + '10',
        borderRadius: 10,
        padding: 15,
        marginRight: 10,
        width: 250,
        borderWidth: 1,
        borderColor: Colors.tertiary + '30',
    }, */
  savedAddressCard: {
    backgroundColor: Colors.white,
    borderRadius: 15,
    padding: 15,
    marginRight: 15,
    width: 280,
    borderWidth: 2,
    borderColor: Colors.primary + "90",
  },
  savedAddressTitle: {
    fontSize: 16,
    fontFamily: "montbold",
    color: Colors.primary,
    marginBottom: 5,
  },
  savedAddressText: {
    fontSize: 14,
    fontFamily: "montregular",
    color: Colors.secondary,
    marginBottom: 3,
  },
  checkoutForm: {
    gap: 12,
  },
  /* checkoutInput: {
        backgroundColor: Colors.tertiary + '10',
        borderRadius: 10,
        padding: 12,
        fontSize: 14,
        fontFamily: 'montregular',
        color: Colors.secondary,
    }, */
  checkoutInput: {
    backgroundColor: Colors.white,
    borderRadius: 12,
    padding: 15,
    fontSize: 14,
    fontFamily: "montregular",
    color: Colors.secondary,
    borderWidth: 1,
    borderColor: Colors.tertiary + "30",
  },
  checkoutInputRow: {
    flexDirection: "row",
    gap: 10,
  },
  checkoutTextArea: {
    minHeight: 80,
    textAlignVertical: "top",
  },
  savedCardsContainer: {
    marginBottom: 15,
  },
  savedCardItem: {
    backgroundColor: Colors.tertiary + "10",
    borderRadius: 10,
    padding: 15,
    marginRight: 10,
    width: 250,
    borderWidth: 1,
    borderColor: Colors.tertiary + "30",
  },
  savedCardNumber: {
    fontSize: 16,
    fontFamily: "montbold",
    color: Colors.primary,
    marginTop: 10,
    marginBottom: 5,
  },
  savedCardName: {
    fontSize: 14,
    fontFamily: "montregular",
    color: Colors.secondary,
    marginBottom: 3,
  },
  savedCardExpiry: {
    fontSize: 14,
    fontFamily: "montregular",
    color: Colors.secondary,
  },
  orderSummary: {
    backgroundColor: Colors.white,
    borderRadius: 15,
    padding: 15,
    marginBottom: 15,
  },
  orderSummaryRow: {
    flexDirection: "row",
    justifyContent: "space-between",
    marginBottom: 10,
  },
  orderSummaryLabel: {
    fontSize: 14,
    fontFamily: "montmedium",
    color: Colors.secondary,
  },
  orderSummaryValue: {
    fontSize: 14,
    fontFamily: "montbold",
    color: Colors.secondary,
  },
  orderTotalRow: {
    borderTopWidth: 1,
    borderTopColor: Colors.tertiary + "20",
    paddingTop: 10,
    marginBottom: 0,
  },
  orderTotalLabel: {
    fontSize: 16,
    fontFamily: "montbold",
    color: Colors.primary,
  },
  orderTotalValue: {
    fontSize: 18,
    fontFamily: "montbold",
    color: Colors.primary,
  },
  paymentButton: {
    flexDirection: "row",
    alignItems: "center",
    justifyContent: "center",
    backgroundColor: Colors.primary,
    padding: 15,
    borderRadius: 10,
    gap: 10,
  },
  paymentButtonText: {
    fontSize: 16,
    fontFamily: "montbold",
    color: Colors.white,
  },
  checkoutSectionDivider: {
    height: 1,
    backgroundColor: Colors.tertiary + "20",
    marginVertical: 15,
  },
  checkoutSavedItemBadge: {
    position: "absolute",
    top: 10,
    right: 10,
    backgroundColor: Colors.success + "20",
    paddingHorizontal: 10,
    paddingVertical: 5,
    borderRadius: 15,
  },
  checkoutSavedItemBadgeText: {
    fontSize: 12,
    fontFamily: "montmedium",
    color: Colors.success,
  },
  checkoutInputLabel: {
    fontSize: 14,
    fontFamily: "montbold",
    color: Colors.primary,
    marginBottom: 5,
  },
  checkoutInputError: {
    fontSize: 12,
    fontFamily: "montregular",
    color: Colors.danger,
    marginTop: 5,
  },
  checkoutInputIcon: {
    position: "absolute",
    right: 12,
    top: 12,
  },
  checkoutSaveCardContainer: {
    flexDirection: "row",
    alignItems: "center",
    marginTop: 10,
    gap: 10,
  },
  checkoutSaveCardText: {
    fontSize: 14,
    fontFamily: "montregular",
    color: Colors.secondary,
  },

  ordersContainer: {
    flex: 1,
    padding: 15,
  },
  orderCard: {
    backgroundColor: Colors.white,
    borderRadius: 15,
    padding: 15,
    marginBottom: 15,
    boxShadow: Colors.tertiary,
    shadowOffset: { width: 0, height: 2 },
    shadowOpacity: 0.1,
    shadowRadius: 4,
    elevation: 3,
  },
  orderHeader: {
    flexDirection: "row",
    justifyContent: "space-between",
    alignItems: "center",
    marginBottom: 15,
  },
  orderNumber: {
    fontSize: 14,
    fontFamily: "montbold",
    color: Colors.primary,
  },
  orderDate: {
    fontSize: 14,
    fontFamily: "montregular",
    color: Colors.secondary,
    marginTop: 5,
  },
  orderStatus: {
    paddingHorizontal: 12,
    paddingVertical: 6,
    borderRadius: 20,
  },
  orderStatusText: {
    fontSize: 12,
    fontFamily: "montbold",
  },
  orderItems: {
    borderTopWidth: 1,
    borderTopColor: Colors.tertiary + "20",
    paddingTop: 15,
  },
  orderItemCard: {
    flexDirection: "row",
    alignItems: "center",
    marginBottom: 10,
  },
  orderItemImage: {
    width: 50,
    height: 50,
    borderRadius: 8,
    marginRight: 10,
  },
  orderItemInfo: {
    flex: 1,
  },
  orderItemName: {
    fontSize: 14,
    fontFamily: "montmedium",
    color: Colors.primary,
    marginBottom: 5,
  },
  orderItemQuantity: {
    fontSize: 12,
    fontFamily: "montregular",
    color: Colors.secondary,
  },
  orderFooter: {
    flexDirection: "row",
    justifyContent: "space-between",
    alignItems: "center",
    borderTopWidth: 1,
    borderTopColor: Colors.tertiary + "20",
    marginTop: 10,
    paddingTop: 15,
  },
  orderTotal: {
    fontSize: 16,
    fontFamily: "montbold",
    color: Colors.primary,
  },

  earningsContainer: {
    flex: 1,
    padding: 15,
  },
  earningsStatsContainer: {
    flexDirection: "row",
    flexWrap: "wrap",
    gap: 10,
    marginBottom: 20,
  },
  earningsStatCard: {
    flex: 1,
    minWidth: "30%",
    backgroundColor: Colors.white,
    borderRadius: 15,
    padding: 15,
    alignItems: "center",
    boxShadow: Colors.tertiary,
    shadowOffset: { width: 0, height: 2 },
    shadowOpacity: 0.1,
    shadowRadius: 4,
    elevation: 3,
  },
  earningsStatAmount: {
    fontSize: 18,
    fontFamily: "montbold",
    color: Colors.primary,
    marginVertical: 8,
    textAlign: "center",
  },
  earningsStatLabel: {
    fontSize: 12,
    fontFamily: "montmedium",
    color: Colors.secondary,
    textAlign: "center",
  },
  salesListContainer: {
    backgroundColor: Colors.white,
    borderRadius: 15,
    padding: 15,
    boxShadow: Colors.tertiary,
    shadowOffset: { width: 0, height: 2 },
    shadowOpacity: 0.1,
    shadowRadius: 4,
    elevation: 3,
  },
  salesListTitle: {
    fontSize: 18,
    fontFamily: "montbold",
    color: Colors.primary,
    marginBottom: 15,
  },
  saleCard: {
    backgroundColor: Colors.tertiary + "10",
    borderRadius: 10,
    padding: 15,
    marginBottom: 10,
  },
  saleHeader: {
    flexDirection: "row",
    justifyContent: "space-between",
    alignItems: "flex-start",
    marginBottom: 10,
  },
  saleOrderNumber: {
    fontSize: 14,
    fontFamily: "montbold",
    color: Colors.primary,
  },
  saleDate: {
    fontSize: 12,
    fontFamily: "montregular",
    color: Colors.secondary,
    marginTop: 4,
  },
  saleTotal: {
    fontSize: 16,
    fontFamily: "montbold",
    color: Colors.success,
  },
  saleDetails: {
    borderTopWidth: 1,
    borderTopColor: Colors.tertiary + "20",
    paddingTop: 10,
  },
  saleCustomer: {
    fontSize: 14,
    fontFamily: "montmedium",
    color: Colors.secondary,
    marginBottom: 5,
  },
  saleProduct: {
    fontSize: 14,
    fontFamily: "montmedium",
    color: Colors.secondary,
    marginBottom: 5,
  },
  saleQuantity: {
    fontSize: 14,
    fontFamily: "montmedium",
    color: Colors.secondary,
  },

  shopCategoryContainer: {
    height: 80,
    justifyContent: "center",
    alignItems: "center",
    width: "100%",
  },

  shopCategory: {
    minWidth: 100,
    height: 50,
    borderRadius: 100,
    alignItems: "center",
    justifyContent: "center",
    padding: 12,
    borderWidth: 1,
    borderColor: Colors.lightGray,
    marginRight: 10,
    marginLeft: 5,
  },

  shopItemsGrid: {
    flexDirection: "row",
    flexWrap: "wrap",
    justifyContent: "space-between",
    padding: 10,
  },
  shopItemCard: {
    width: "48%",
    backgroundColor: "white",
    borderRadius: 10,
    padding: 10,
    marginBottom: 15,
    boxShadow: "#000",
    shadowOffset: {
      width: 0,
      height: 2,
    },
    shadowOpacity: 0.25,
    shadowRadius: 3.84,
    elevation: 5,
  },
  shopItemImage: {
    width: "100%",
    height: 150,
    borderRadius: 8,
    marginBottom: 8,
    resizeMode: "contain",
  },
  shopItemName: {
    fontSize: 16,
    fontWeight: "600",
    marginBottom: 4,
  },
  shopItemPrice: {
    fontSize: 14,
    color: Colors.primary,
    fontWeight: "700",
    marginBottom: 8,
  },
  addToCartButton: {
    backgroundColor: Colors.primary,
    padding: 8,
    borderRadius: 5,
    alignItems: "center",
  },
  addToCartButtonText: {
    color: Colors.white,
    fontSize: 14,
    fontWeight: "600",
  },

  whiteTopbarContainer: {
    flexDirection: "row",
    alignItems: "center",
    justifyContent: "space-between",
    backgroundColor: Colors.white,
    paddingVertical: 10,
    paddingHorizontal: 15,
    height: 65,
    paddingTop: 15,
    borderBottomWidth: 1,
    borderBottomColor: Colors.primary,
  },

  whiteTopbarTitle: {
    color: Colors.primary,
    fontSize: 24,
    fontWeight: "bold",
  },

  NotificationCountContainer: {
    position: "absolute",
    right: -7,
    top: -7,
    backgroundColor: Colors.danger,
    borderRadius: 100,
    width: 17,
    height: 17,
    alignItems: "center",
    justifyContent: "center",
  },

  cartItemSummaryName: {
    fontSize: 14,
    fontWeight: "500",
    color: Colors.tertiary,
    flex: 1,
  },
  cartItemSummarySize: {
    fontSize: 12,
    color: Colors.secondary,
    fontStyle: "italic",
    marginTop: 2,
  },

  CartItemCountContainer: {
    position: "absolute",
    right: 0,
    top: 0,
    backgroundColor: Colors.danger,
    borderRadius: 100,
    width: 17,
    height: 17,
    alignItems: "center",
    justifyContent: "center",
  },

  TopbarCountText: {
    color: Colors.white,
    fontFamily: "montbold",
    fontSize: 12,
  },

  ReferanceCodeTextTitle: {
    fontSize: 18,
    color: Colors.tertiary,
    fontFamily: "montbold",
    textAlign: "center",
  },

  ReferanceCodeText: {
    fontSize: 28,
    color: Colors.primary,
    fontFamily: "montbold",
    flex: 1,
    textAlign: "center",
    marginTop: 10,
  },

  referralHeaderContainer: {
    flexDirection: "row",
    alignItems: "center",
    marginBottom: 15,
    gap: 10,
  },
  referralTitle: {
    fontSize: 18,
    fontFamily: "montbold",
    color: Colors.primary,
  },
  referralDescription: {
    fontSize: 14,
    fontFamily: "montregular",
    color: Colors.secondary,
    marginBottom: 15,
  },
  referralCodeContainer: {
    flexDirection: "row",
    alignItems: "center",
    gap: 10,
    marginBottom: 20,
  },
  referralCodeBox: {
    flex: 1,
    backgroundColor: Colors.tertiary + "10",
    borderRadius: 10,
    padding: 10,
    flexDirection: "row",
    alignItems: "center",
    columnGap: 10,
  },
  referralCodeLabel: {
    fontSize: 15,
    fontFamily: "montmedium",
    color: Colors.secondary,
  },
  referralCodeText: {
    fontSize: 18,
    fontFamily: "montbold",
    color: Colors.primary,
    letterSpacing: 2,
  },
  referralCopyButton: {
    backgroundColor: Colors.primary,
    width: 50,
    height: 50,
    borderRadius: 10,
    justifyContent: "center",
    alignItems: "center",
  },
  referralStatsContainer: {
    flexDirection: "row",
    justifyContent: "space-between",
    marginBottom: 20,
  },
  referralStatItem: {
    flex: 1,
    alignItems: "center",
    backgroundColor: Colors.tertiary + "10",
    borderRadius: 10,
    padding: 15,
    marginHorizontal: 5,
  },
  referralStatNumber: {
    fontSize: 20,
    fontFamily: "montbold",
    color: Colors.primary,
    marginBottom: 5,
  },
  referralStatLabel: {
    fontSize: 12,
    fontFamily: "montmedium",
    color: Colors.secondary,
  },
  referralShareButton: {
    flexDirection: "row",
    alignItems: "center",
    justifyContent: "center",
    backgroundColor: Colors.primary,
    padding: 15,
    borderRadius: 10,
    gap: 10,
  },
  referralShareButtonText: {
    color: Colors.white,
    fontSize: 16,
    fontFamily: "montbold",
  },

  adWatchButton: {
    alignItems: "center",
    justifyContent: "center",
    backgroundColor: Colors.primary,
    borderRadius: 10,
    width: 40,
    height: 40,
  },

  adWatchText: {
    fontSize: 16,
    fontFamily: "montbold",
    color: Colors.primary,
  },

  AdWatchContainer: {
    flexDirection: "row",
    alignItems: "center",
    justifyContent: "space-between",
    marginTop: 20,
  },

  orderItemCard: {
    flexDirection: "row",
    alignItems: "center",
    backgroundColor: Colors.white,
    padding: 12,
    marginBottom: 10,
    borderRadius: 12,
    boxShadow: Colors.tertiary,
    shadowOffset: { width: 0, height: 2 },
    shadowOpacity: 0.1,
    shadowRadius: 4,
    elevation: 3,
  },
  orderItemImageContainer: {
    position: "relative",
    marginRight: 15,
  },
  orderItemImage: {
    width: 60,
    height: 60,
    borderRadius: 10,
  },
  orderItemQuantityBadge: {
    position: "absolute",
    top: -8,
    right: -8,
    backgroundColor: Colors.primary,
    borderRadius: 12,
    width: 24,
    height: 24,
    justifyContent: "center",
    alignItems: "center",
  },
  orderItemQuantityText: {
    color: Colors.white,
    fontSize: 12,
    fontFamily: "montbold",
  },
  orderItemInfo: {
    flex: 1,
  },
  orderItemName: {
    fontSize: 15,
    fontFamily: "montbold",
    color: Colors.tertiary,
    marginBottom: 4,
  },
  orderItemPrice: {
    fontSize: 14,
    fontFamily: "montmedium",
    color: Colors.primary,
  },
  orderCard: {
    backgroundColor: Colors.white,
    borderRadius: 15,
    padding: 15,
    marginBottom: 15,
    boxShadow: Colors.tertiary,
    shadowOffset: { width: 0, height: 4 },
    shadowOpacity: 0.15,
    shadowRadius: 6,
    elevation: 5,
    borderWidth: 1,
    borderColor: Colors.tertiary + "10",
  },

  cartItemContainer: {
    backgroundColor: Colors.white,
    borderRadius: 15,
    marginBottom: 15,
    padding: 12,
    boxShadow: Colors.tertiary,
    shadowOffset: { width: 0, height: 3 },
    shadowOpacity: 0.1,
    shadowRadius: 5,
    elevation: 4,
    borderWidth: 1,
    borderColor: Colors.tertiary + "10",
  },
  cartItemImageWrapper: {
    position: "relative",
    marginBottom: 10,
  },
  cartItemImage: {
    width: "100%",
    height: 150,
    borderRadius: 12,
  },
  cartItemBadge: {
    position: "absolute",
    top: 8,
    right: 8,
    backgroundColor: Colors.primary,
    borderRadius: 15,
    width: 30,
    height: 30,
    justifyContent: "center",
    alignItems: "center",
  },
  cartItemBadgeText: {
    color: Colors.white,
    fontSize: 14,
    fontFamily: "montbold",
  },
  cartItemContent: {
    padding: 8,
  },
  cartItemHeader: {
    flexDirection: "row",
    justifyContent: "space-between",
    alignItems: "flex-start",
    marginBottom: 12,
  },
  cartItemFooter: {
    flexDirection: "row",
    justifyContent: "space-between",
    alignItems: "center",
    marginTop: 8,
  },
  quantityButton: {
    backgroundColor: Colors.tertiary + "10",
    borderRadius: 8,
    width: 32,
    height: 32,
    justifyContent: "center",
    alignItems: "center",
  },
  quantityText: {
    fontSize: 16,
    fontFamily: "montbold",
    color: Colors.primary,
    marginHorizontal: 12,
  },

  cartItemQuantityControls: {
    flexDirection: "row",
    alignItems: "center",
    justifyContent: "center",
  },

  productDetailContainer: {
    flex: 1,
    backgroundColor: Colors.white,
  },
  productDetailInfo: {
    padding: 20,
    backgroundColor: Colors.white,
    borderTopLeftRadius: 25,
    borderTopRightRadius: 25,
    marginTop: -20,
    boxShadow: Colors.tertiary,
    shadowOffset: { width: 0, height: -3 },
    shadowOpacity: 0.1,
    shadowRadius: 5,
    elevation: 5,
  },
  productDetailName: {
    fontSize: 24,
    fontFamily: "montbold",
    color: Colors.primary,
    marginBottom: 8,
  },
  productDetailPrice: {
    fontSize: 22,
    fontFamily: "montbold",
    color: Colors.secondary,
    marginBottom: 20,
  },
  productDetailSectionTitle: {
    fontSize: 18,
    fontFamily: "montbold",
    color: Colors.primary,
    marginBottom: 12,
    marginTop: 15,
  },
  productDetailDescription: {
    fontSize: 15,
    fontFamily: "montregular",
    color: Colors.secondary,
    lineHeight: 24,
    textAlign: "justify",
  },
  productDetailActionBar: {
    flexDirection: "row",
    padding: 15,
    backgroundColor: Colors.white,
    borderTopWidth: 1,
    borderTopColor: Colors.tertiary + "20",
    gap: 15,
  },
  productDetailQuantity: {
    flexDirection: "row",
    alignItems: "center",
    backgroundColor: Colors.lightGray + "90",
    borderRadius: 12,
    padding: 5,
    flex: 1.2,
    justifyContent: "center",
  },
  productDetailQuantityButton: {
    padding: 8,
    borderRadius: 8,
    backgroundColor: Colors.white,
  },
  productDetailQuantityText: {
    fontSize: 20,
    fontFamily: "montbold",
    color: Colors.primary,
    paddingHorizontal: 12,
  },
  productDetailAddToCart: {
    flex: 2,
    flexDirection: "row",
    alignItems: "center",
    justifyContent: "center",
    backgroundColor: Colors.primary,
    borderRadius: 12,
    padding: 15,
    gap: 10,
  },
  productDetailAddToCartText: {
    color: Colors.white,
    fontSize: 16,
    fontFamily: "montbold",
  },

  ChatPageMessageImage: {
    width: "100%",
    height: "100%",
    borderRadius: 15,
  },

  chatInputWrapper: {
    backgroundColor: Colors.white,
    borderTopWidth: 1,
    borderTopColor: Colors.lightGray,
    paddingBottom: 0,
  },

  chatInputContainer: {
    flexDirection: "row",
    alignItems: "center",
    paddingHorizontal: 10,
    paddingVertical: 8,
    backgroundColor: Colors.white,
    minHeight: 50,
    paddingBottom: 0,
  },
});
