"""Add is_valid column to password_reset

Revision ID: 109ba3d7ca56
Revises: 
Create Date: 2025-02-08 23:01:08.807517

"""
from typing import Sequence, Union

from alembic import op
import sqlalchemy as sa
from sqlalchemy.dialects import mysql

# revision identifiers, used by Alembic.
revision: str = '109ba3d7ca56'
down_revision: Union[str, None] = None
branch_labels: Union[str, Sequence[str], None] = None
depends_on: Union[str, Sequence[str], None] = None


def upgrade():
    connection = op.get_bind()
    # 우선 users 테이블에서 해당 인덱스가 있는지 확인합니다.
    result = connection.execute("SHOW INDEX FROM users WHERE Key_name='idx_country'").fetchall()
    if result:
        op.drop_index('idx_country', table_name='users')
        op.add_column('password_reset', sa.Column('is_valid', sa.Boolean(), nullable=True))
        def downgrade():
        op.drop_column('password_reset', 'is_valid')
        # 필요하다면 인덱스 복원 로직도 추가
