"""Add column user address title

Revision ID: 18fbbbef4f90
Revises: b43b32dbe7d2
Create Date: 2025-02-25 14:47:05.466211

"""
from typing import Sequence, Union

from alembic import op
import sqlalchemy as sa
from sqlalchemy import inspect


# revision identifiers, used by Alembic.
revision: str = '18fbbbef4f90'
down_revision: Union[str, None] = 'b43b32dbe7d2'
branch_labels: Union[str, Sequence[str], None] = None
depends_on: Union[str, Sequence[str], None] = None


def upgrade() -> None:
    # 테이블이 존재하는지 확인
    conn = op.get_bind()
    inspector = inspect(conn)
    
    # user_addresses 테이블이 있는 경우에만 진행
    if 'user_addresses' in inspector.get_table_names():
        # 컬럼이 이미 존재하는지 확인
        columns = [c['name'] for c in inspector.get_columns('user_addresses')]
        if 'title' not in columns:
            op.add_column('user_addresses',
                sa.Column('title', sa.String(50), nullable=False,
                          server_default='기본 주소')
            )
            # (옵션) 서버 디폴트 제거: 기존 데이터가 업데이트된 후 디폴트를 제거할 수 있음
            op.alter_column('user_addresses', 'title', server_default=None)


def downgrade() -> None:
    # 테이블이 존재하는지 확인
    conn = op.get_bind()
    inspector = inspect(conn)
    
    # user_addresses 테이블이 있는 경우에만 진행
    if 'user_addresses' in inspector.get_table_names():
        # 컬럼이 존재하는지 확인
        columns = [c['name'] for c in inspector.get_columns('user_addresses')]
        if 'title' in columns:
            op.drop_column('user_addresses', 'title')
