"""change column order user address title

Revision ID: 1c6d27b99f5b
Revises: cc436963c774
Create Date: 2025-02-25 15:10:15.833494

"""
from typing import Sequence, Union

from alembic import op
import sqlalchemy as sa


# revision identifiers, used by Alembic.
revision: str = '1c6d27b99f5b'
down_revision: Union[str, None] = 'cc436963c774'
branch_labels: Union[str, Sequence[str], None] = None
depends_on: Union[str, Sequence[str], None] = None


def upgrade() -> None:
    # title 컬럼을 user_id 오른쪽으로 재배치 (MySQL 전용 쿼리)
    op.execute("ALTER TABLE user_addresses MODIFY COLUMN title VARCHAR(50) NOT NULL AFTER user_id;")


def downgrade() -> None:
    # downgrade 시 title 컬럼을 TABLE 마지막 열로 위치 변경 (AFTER 사용하지 않음)
    op.execute("ALTER TABLE user_addresses MODIFY COLUMN title VARCHAR(50) NOT NULL;")
