"""Add column user is_admin

Revision ID: 29d929f4af8b
Revises: 1c6d27b99f5b
Create Date: 2025-02-26 15:21:04.738702

"""
from typing import Sequence, Union

from alembic import op
import sqlalchemy as sa


# revision identifiers, used by Alembic.
revision: str = '29d929f4af8b'
down_revision: Union[str, None] = '1c6d27b99f5b'
branch_labels: Union[str, Sequence[str], None] = None
depends_on: Union[str, Sequence[str], None] = None


def upgrade() -> None:
    # Add the 'is_admin' column to the 'users' table with default False.
    op.add_column('users', sa.Column('is_admin', sa.Boolean(), nullable=False, server_default=sa.text('0')))
    # Optionally remove the server_default if you don't want it permanently
    op.alter_column('users', 'is_admin', server_default=None)


def downgrade() -> None:
    # Drop the 'is_admin' column
    op.drop_column('users', 'is_admin')
