"""update for the notification of step tracking record

Revision ID: 2a8580c38e8c
Revises: f71e01b5ee3c
Create Date: 2025-03-05 08:46:27.324141

"""
from typing import Sequence, Union

from alembic import op
import sqlalchemy as sa


# revision identifiers, used by Alembic.
revision: str = '2a8580c38e8c'
down_revision: Union[str, None] = 'f71e01b5ee3c'
branch_labels: Union[str, Sequence[str], None] = None
depends_on: Union[str, Sequence[str], None] = None


def upgrade() -> None:
    # Add new columns to the users table
    op.add_column('users', sa.Column('step_notification_frequency', sa.Integer(), nullable=False, server_default='3'))
    op.add_column('users', sa.Column('last_step_notification_time', sa.DateTime(), nullable=True))
    op.add_column('users', sa.Column('step_notifications_sent_today', sa.Integer(), nullable=False, server_default='0'))
    # Remove server default now that columns are created (optional)
    with op.batch_alter_table('users') as batch_op:
        batch_op.alter_column('step_notification_frequency', server_default=None)
        batch_op.alter_column('step_notifications_sent_today', server_default=None)


def downgrade() -> None:
    # Drop the columns added in upgrade
    op.drop_column('users', 'step_notifications_sent_today')
    op.drop_column('users', 'last_step_notification_time')
    op.drop_column('users', 'step_notification_frequency')
