"""Drop image_url and thumbnail_image_id from products

Revision ID: 480534f90202
Revises: beab368d7d1e
Create Date: 2025-02-11 11:51:27.768601

"""
from typing import Sequence, Union

from alembic import op
import sqlalchemy as sa


# revision identifiers, used by Alembic.
revision: str = '480534f90202'
down_revision: Union[str, None] = 'beab368d7d1e'
branch_labels: Union[str, Sequence[str], None] = None
depends_on: Union[str, Sequence[str], None] = None


def upgrade() -> None:
    # 먼저 외래키 제약조건 제거 (thumbnail_image_id에 대해)
    op.drop_constraint('fk_products_thumbnail_image_id', 'products', type_='foreignkey')
    
    # thumbnail_image_id 컬럼 제거
    op.drop_column('products', 'thumbnail_image_id')
    
    # image_url 컬럼 제거
    op.drop_column('products', 'image_url')

def downgrade() -> None:
    # downgrade 시 원래 상태로 복구하려면 컬럼들을 다시 추가해야 합니다.
    op.add_column('products', sa.Column('image_url', sa.String(255), nullable=True))
    op.add_column('products', sa.Column('thumbnail_image_id', sa.Integer(), nullable=True))
    
    # thumbnail_image_id 컬럼에 대한 외래키 제약조건 다시 추가
    op.create_foreign_key(
        'fk_products_thumbnail_image_id',
        'products',
        'product_images',
        ['thumbnail_image_id'],
        ['id'],
        ondelete="SET NULL"
    )