"""Add advertisements table

Revision ID: 5673962035f1
Revises: 5101c3bd185a
Create Date: 2025-02-21 19:20:20.749300

"""
from typing import Sequence, Union

from alembic import op
import sqlalchemy as sa
from sqlalchemy.dialects import mysql

# revision identifiers, used by Alembic.
revision: str = '5673962035f1'
down_revision: Union[str, None] = '5101c3bd185a'
branch_labels: Union[str, Sequence[str], None] = None
depends_on: Union[str, Sequence[str], None] = None


def upgrade():
    op.create_table(
        'advertisements',
        sa.Column('id', mysql.BIGINT(unsigned=True), primary_key=True, autoincrement=True),
        sa.Column('ad_url', sa.String(255), nullable=False),
        sa.Column('video_list_order', sa.Integer(), nullable=False),
        sa.Column('ad_video_points', sa.Integer(), nullable=False),
        # MySQL의 BOOLEAN은 0, 1로 저장되므로 server_default를 텍스트 '0'으로 설정합니다.
        sa.Column('ad_clicked', sa.Boolean(), nullable=False, server_default=sa.text('0')),
        sa.Column('ad_click_time', sa.DateTime(), nullable=True),
        # created_at은 서버에서 현재 시간으로 설정 (MySQL의 경우 sa.func.now() 사용)
        sa.Column('created_at', sa.DateTime(), nullable=False, server_default=sa.func.now()),
    )

def downgrade():
    op.drop_table('advertisements')