"""Modify the messages table

Revision ID: 61d3d93910c2
Revises: 66f3bada1b7c
Create Date: 2025-02-14 14:05:43.732456

"""
from typing import Sequence, Union

from alembic import op
import sqlalchemy as sa


# revision identifiers, used by Alembic.
revision: str = '61d3d93910c2'
down_revision: Union[str, None] = '66f3bada1b7c'
branch_labels: Union[str, Sequence[str], None] = None
depends_on: Union[str, Sequence[str], None] = None


def upgrade() -> None:
    # Add the 'is_read' column to the messages table with a default value of 0 (False)
    op.add_column('messages', 
                  sa.Column('is_read', sa.Boolean(), nullable=False, server_default=sa.text('0')))
    # Optionally remove the server default after adding the column
    op.alter_column('messages', 'is_read', server_default=None)


def downgrade() -> None:
    # Remove the 'is_read' column from the messages table
    op.drop_column('messages', 'is_read')
