"""adjust user_referral and according to the actual production environment product

Revision ID: b61c52e24249
Revises: 61d3d93910c2
Create Date: 2025-02-19 16:26:05.048652

"""
from typing import Sequence, Union

from alembic import op
import sqlalchemy as sa


# revision identifiers, used by Alembic.
revision: str = 'b61c52e24249'
down_revision: Union[str, None] = '61d3d93910c2'
branch_labels: Union[str, Sequence[str], None] = None
depends_on: Union[str, Sequence[str], None] = None


def upgrade() -> None:
    # Create new indexes on products table
    op.create_index('idx_status', 'products', ['status'])
    op.create_index('idx_points', 'products', ['points_required'])
    op.create_index('idx_product_category', 'products', ['category_id', 'status'])

    # Add 'awarded' column to user_referrals table with a default value (False)
    op.add_column(
        'user_referrals',
        sa.Column('awarded', sa.Boolean(), nullable=False, server_default=sa.text("0"))
    )
    # Optionally remove the server_default (if not needed for future inserts)
    with op.batch_alter_table("user_referrals") as batch_op:
        batch_op.alter_column('awarded', server_default=None)


def downgrade() -> None:
    # Remove indexes from products table (reverse order)
    op.drop_index('idx_product_category', table_name='products')
    op.drop_index('idx_points', table_name='products')
    op.drop_index('idx_status', table_name='products')

    # Drop 'awarded' column from user_referrals table
    op.drop_column('user_referrals', 'awarded')
