"""Add thumbnail_image_id FK to products

Revision ID: beab368d7d1e
Revises: fc43a739a5c5
Create Date: 2025-02-11 11:38:38.944329

"""
from typing import Sequence, Union

from alembic import op
import sqlalchemy as sa


# revision identifiers, used by Alembic.
revision: str = 'beab368d7d1e'
down_revision: Union[str, None] = 'fc43a739a5c5'
branch_labels: Union[str, Sequence[str], None] = None
depends_on: Union[str, Sequence[str], None] = None


def upgrade() -> None:
     # 새 컬럼 추가 (nullable로 시작)
      op.add_column(
          'products',
          sa.Column('thumbnail_image_id', sa.Integer(), nullable=True)
      )
      # 외래키 제약조건 추가: thumbnail_image_id -> product_images.id
      op.create_foreign_key(
          'fk_products_thumbnail_image_id',
          'products',
          'product_images',
          ['thumbnail_image_id'],
          ['id'],
          ondelete="SET NULL"  # 필요에 따라 조정
      )


def downgrade() -> None:
    op.drop_constraint('fk_products_thumbnail_image_id', 'products', type_='foreignkey')
    op.drop_column('products', 'thumbnail_image_id')
