"""Force add title column to user_addresses

Revision ID: cc436963c774
Revises: 18fbbbef4f90
Create Date: 2025-02-25 12:00:06.898777

"""
from typing import Sequence, Union

from alembic import op
import sqlalchemy as sa


# revision identifiers, used by Alembic.
revision: str = 'cc436963c774'
down_revision: Union[str, None] = '18fbbbef4f90'
branch_labels: Union[str, Sequence[str], None] = None
depends_on: Union[str, Sequence[str], None] = None


def upgrade() -> None:
    op.add_column('user_addresses',
        sa.Column('title', sa.String(50), nullable=False, server_default='default address')
    )
    # MySQL 전용: title 컬럼을 user_id 다음에 위치하도록 재배치
    op.execute("ALTER TABLE user_addresses MODIFY COLUMN title VARCHAR(50) NOT NULL AFTER user_id;")
    # 서버 디폴트를 제거합니다.
    op.alter_column('user_addresses', 'title', server_default=None)

def downgrade() -> None:
    op.drop_column('user_addresses', 'title')
