"""device_token model and schema

Revision ID: f71e01b5ee3c
Revises: bf497e8e533f
Create Date: 2025-02-28 22:59:40.633075

"""
from typing import Sequence, Union

from alembic import op
import sqlalchemy as sa
from sqlalchemy.dialects.mysql import BIGINT


# revision identifiers, used by Alembic.
revision: str = 'f71e01b5ee3c'
down_revision: Union[str, None] = 'bf497e8e533f'
branch_labels: Union[str, Sequence[str], None] = None
depends_on: Union[str, Sequence[str], None] = None


def upgrade():
    conn = op.get_bind()
    if not conn.dialect.has_table(conn, "device_tokens"):
        op.create_table(
            'device_tokens',
            sa.Column('id', BIGINT(unsigned=True), autoincrement=True, nullable=False),
            sa.Column('user_id', BIGINT(unsigned=True), nullable=False),
            sa.Column('device_token', sa.String(255), nullable=False),
            sa.Column('device_type', sa.String(20), nullable=False),
            sa.Column('is_active', sa.Boolean(), nullable=False, default=True),
            sa.Column('created_at', sa.DateTime(), nullable=False),
            sa.Column('updated_at', sa.DateTime(), nullable=False),
            sa.ForeignKeyConstraint(['user_id'], ['users.id'], ondelete='CASCADE'),
            sa.PrimaryKeyConstraint('id')
        )
        op.create_index('idx_user_device', 'device_tokens', ['user_id', 'device_token'], unique=True)
        op.create_index('idx_device_token', 'device_tokens', ['device_token'])
    else:
        print("Table 'device_tokens' already exists. Skipping creation.")


def downgrade():
    op.drop_index('idx_device_token', table_name='device_tokens')
    op.drop_index('idx_user_device', table_name='device_tokens')
    op.drop_table('device_tokens') 