"""Add is_valid column to password_reset

Revision ID: fa37fa53111f
Revises: 109ba3d7ca56
Create Date: 2025-02-08 23:35:57.249012

"""
from typing import Sequence, Union

from alembic import op
import sqlalchemy as sa
from sqlalchemy.dialects import mysql

# revision identifiers, used by Alembic.
revision: str = 'fa37fa53111f'
down_revision: Union[str, None] = '109ba3d7ca56'
branch_labels: Union[str, Sequence[str], None] = None
depends_on: Union[str, Sequence[str], None] = None

def upgrade():
    op.add_column('password_reset', sa.Column('is_valid', sa.Integer(), nullable=False, server_default='1'))
    # 이미 존재하는 데이터가 모두 1이 되도록 하고, 추후 별도의 migration에서 server_default를 제거할 수도 있습니다.

def downgrade():
    op.drop_column('password_reset', 'is_valid')
