"""Add FK to products.category_id

Revision ID: fc43a739a5c5
Revises: ec77c5cf5215
Create Date: 2025-02-11 10:59:48.755959

"""
from typing import Sequence, Union

from alembic import op
import sqlalchemy as sa


# revision identifiers, used by Alembic.
revision: str = 'fc43a739a5c5'
down_revision: Union[str, None] = 'ec77c5cf5215'
branch_labels: Union[str, Sequence[str], None] = None
depends_on: Union[str, Sequence[str], None] = None


def upgrade() -> None:
    op.add_column(
        'products',
        sa.Column('thumbnail_image_id', sa.Integer(), nullable=True)
    )
    # 외래키 제약조건 추가: thumbnail_image_id -> product_images.id
    op.create_foreign_key(
        'fk_products_thumbnail_image_id',
        'products',
        'product_images',
        ['thumbnail_image_id'],
        ['id'],
        ondelete="SET NULL"  # 예제 옵션, 필요에 따라 조정
    )


def downgrade() -> None:
    op.drop_constraint('fk_products_thumbnail_image_id', 'products', type_='foreignkey')
    # thumbnail_image_id 컬럼 제거
    op.drop_column('products', 'thumbnail_image_id')
