# app/api/v1/api.py
from fastapi import APIRouter
from app.api.v1.endpoints import friendships, users
from app.api.v1.endpoints import notifications
from app.api.v1.endpoints import auth
from app.api.v1.endpoints import products
from app.api.v1.endpoints import product_images
from app.api.v1.endpoints import product_categories
from app.api.v1.endpoints import shopping_cart
from app.api.v1.endpoints import messages
from app.api.v1.endpoints import ws_chat
from app.api.v1.endpoints import steps
from app.api.v1.endpoints import points
from app.api.v1.endpoints import referrals
from app.api.v1.endpoints import advertisements
from app.api.v1.endpoints import order
from app.api.v1.endpoints import user_addresses
from app.api.v1.endpoints import admin
from app.api.v1.endpoints import device_tokens
from app.api.v1.endpoints import push_notifications

# APIRouter 생성 시 redirect_slashes 옵션 설정
api_router = APIRouter()

api_router.include_router(users.router, prefix="/users", tags=["users"])
api_router.include_router(notifications.router, prefix="/notifications", tags=["notifications"])
api_router.include_router(auth.router, prefix="/auth", tags=["auth"])
api_router.include_router(products.router, prefix="/products", tags=["products"])
api_router.include_router(product_images.router, tags=["product-images"])
api_router.include_router(product_categories.router, prefix="/categories", tags=["categories"])
api_router.include_router(shopping_cart.router, prefix="/shopping-cart", tags=["shopping-cart"])
api_router.include_router(messages.router, prefix="/messages", tags=["messages"])
api_router.include_router(ws_chat.router, prefix="/ws-chat", tags=["ws-chat"])
api_router.include_router(friendships.router, prefix="/friendships", tags=["friendships"])
api_router.include_router(steps.router, prefix="/steps", tags=["steps"])
api_router.include_router(points.router, prefix="/points", tags=["points"])
api_router.include_router(referrals.router, prefix="/referrals", tags=["referrals"])
api_router.include_router(advertisements.router, prefix="/advertisements", tags=["advertisements"])
api_router.include_router(order.router, prefix="/orders", tags=["orders"])
api_router.include_router(user_addresses.router, prefix="/addresses", tags=["addresses"])
api_router.include_router(admin.router, prefix="/admin", tags=["admin"])
api_router.include_router(device_tokens.router, prefix="/device-tokens", tags=["device-tokens"])
api_router.include_router(push_notifications.router, prefix="/push-notifications", tags=["push-notifications"])