from fastapi import APIRouter, HTTPException, Depends
from sqlalchemy.orm import Session
from typing import List

from app.schemas.product_category import ProductCategoryBase, ProductCategoryResponse
from app.services.product_service import ProductService
from app.api import deps
from app.models.product_category import ProductCategory

router = APIRouter()

@router.get("/", response_model=List[ProductCategoryResponse])
def list_product_categories(db: Session = Depends(deps.get_db)):
    """
    Retrieve all product categories.
    This endpoint can be used for filtering product lists on the frontend.
    """
    # Return all ProductCategory objects by default.
    categories = db.query(ProductCategory).all()
    if not categories:
        raise HTTPException(status_code=404, detail="No product categories found")
    return categories

@router.post("/", response_model=ProductCategoryResponse)
def create_product_category(category_in: ProductCategoryBase, db: Session = Depends(deps.get_db)):
    """
    Create a new product category.
    """
    return ProductService.create_product_category(db, category_in)
