from fastapi import APIRouter, HTTPException, Depends
from sqlalchemy.orm import Session
from typing import List
from pydantic import BaseModel

from app.api import deps
from app.services.product_service import ProductService
from app.models.product import Product

router = APIRouter()

class UpdateProductImagesRequest(BaseModel):
    images: List[str]

@router.put("/products/{product_id}/images")
def update_product_images_endpoint(
    product_id: int, 
    payload: UpdateProductImagesRequest, 
    db: Session = Depends(deps.get_db)
):
    return ProductService.update_product_images(db, product_id, payload.images)

@router.delete("/products/{product_id}/images")
def delete_product_images_endpoint(
    product_id: int, 
    db: Session = Depends(deps.get_db)
):
    product = db.query(Product).filter(Product.id == product_id).first()
    if not product:
        raise HTTPException(status_code=404, detail="Product not found")
    
    # 모든 이미지 삭제
    product.images.clear()
    db.commit()  # 이미지 삭제 커밋
    
    return {"message": "Product images deleted successfully."}
