from fastapi import APIRouter, Depends
from sqlalchemy.orm import Session
from sqlalchemy import func

from app.models.user_referral import UserReferral
from app.api.deps import get_db, get_current_user
from app.models.user import User

router = APIRouter()

@router.get("/count", tags=["referrals"])
async def get_referral_count(
    current_user: User = Depends(get_current_user),
    db: Session = Depends(get_db)
):
    """
    로그인한 사용자가 추천인(referrer_user_id)으로서 유치한 회원 수를 반환합니다.
    예를 들어, user 16이 4명의 회원(21,22,24,25)을 추천했으면 count는 4가 됩니다.
    """
    # SQLAlchemy의 func.count()를 사용하여 추천 건수를 조회합니다.
    referral_count = db.query(func.count(UserReferral.id)).filter(
        UserReferral.referrer_user_id == current_user.id
    ).scalar()
    return {"referral_count": referral_count}
