import logging
import sys
import os
from logging.handlers import RotatingFileHandler

def setup_logging():
    # Create logger
    logger = logging.getLogger('adimsayar')
    
    # 이미 핸들러가 설정되어 있다면 리턴
    if logger.handlers:
        return logger
        
    logger.setLevel(logging.INFO)
    
    # 기존 핸들러 제거
    logger.handlers.clear()

    # Create formatters
    formatter = logging.Formatter(
        '%(levelname)s:%(message)s'  # 더 간단한 포맷으로 변경
    )

    # Create console handler
    console_handler = logging.StreamHandler(sys.stdout)
    console_handler.setFormatter(formatter)
    console_handler.setLevel(logging.INFO)

    # Get absolute path for logs
    current_dir = os.path.dirname(os.path.dirname(os.path.dirname(os.path.abspath(__file__))))
    log_file_path = os.path.join(current_dir, 'logs', 'adimsayar.log')

    # Create file handler
    file_handler = RotatingFileHandler(
        log_file_path,
        maxBytes=10485760,  # 10MB
        backupCount=5
    )
    file_handler.setFormatter(formatter)
    file_handler.setLevel(logging.INFO)

    # Add handlers to logger
    logger.addHandler(console_handler)
    logger.addHandler(file_handler)

    # Prevent propagation to root logger
    logger.propagate = False

    return logger 