from sqlalchemy import Column, String, DateTime, func
from sqlalchemy.dialects.mysql import BIGINT
from app.db.base import Base
from app.core.time import now

class AdminSetting(Base):
    __tablename__ = "admin_settings"

    id = Column(BIGINT(unsigned=True), primary_key=True, autoincrement=True)
    setting_name = Column(String(50), nullable=False)
    setting_value = Column(String(100), nullable=True)
    country_code = Column(String(5), nullable=True)
    updated_at = Column(
        DateTime, nullable=False, default=now, onupdate=now
    )