from sqlalchemy import Column, String, DateTime, Integer
from sqlalchemy.dialects.mysql import BIGINT
from app.db.base import Base
from app.core.time import now

class Advertisement(Base):
    __tablename__ = "advertisements"

    id = Column(BIGINT(unsigned=True), primary_key=True, autoincrement=True)
    # 광고 URL
    ad_url = Column(String(255), nullable=False)
    # 광고 비디오가 나열될 순서
    video_list_order = Column(Integer, nullable=False)
    # 광고 비디오에 해당하는 포인트
    ad_video_points = Column(Integer, nullable=False)
    # 생성일시
    created_at = Column(DateTime, default=now, nullable=False)
