from sqlalchemy import Column, DateTime, ForeignKey, UniqueConstraint
from sqlalchemy.dialects.mysql import BIGINT
from app.db.base import Base
from app.core.time import now

class AdvertisementClickRecord(Base):
    __tablename__ = "advertisement_click_records"
    __table_args__ = (
        UniqueConstraint("user_id", "advertisement_id", name="uq_ad_click_user_ad"),
    )

    id = Column(BIGINT(unsigned=True), primary_key=True, autoincrement=True)
    user_id = Column(BIGINT(unsigned=True), ForeignKey("users.id", ondelete="CASCADE"), nullable=False)
    advertisement_id = Column(BIGINT(unsigned=True), ForeignKey("advertisements.id", ondelete="CASCADE"), nullable=False)
    clicked_at = Column(DateTime, nullable=False, default=now) 