from sqlalchemy import Column, ForeignKey, Integer, DateTime, func
from sqlalchemy.dialects.mysql import BIGINT
from sqlalchemy.orm import relationship
from app.db.base import Base

class CartItem(Base):
    __tablename__ = "cart_items"

    id = Column(BIGINT(unsigned=True), primary_key=True, autoincrement=True)
    cart_id = Column(BIGINT(unsigned=True), ForeignKey("shopping_carts.id", ondelete="CASCADE"), nullable=False)
    product_id = Column(BIGINT(unsigned=True), ForeignKey("products.id"), nullable=False)
    quantity = Column(Integer, nullable=False, default=1)
    created_at = Column(DateTime, nullable=False, default=func.now())
    updated_at = Column(DateTime, nullable=False, default=func.now(), onupdate=func.now())

    # This property allows retrieval of the associated shopping cart.
    shopping_cart = relationship("ShoppingCart", back_populates="items")
