from sqlalchemy import (
    Column,
    String,
    Text,
    Integer,
    Date,
    JSON,
    DateTime,
    Enum,
    Index,
    func,
)
from sqlalchemy.dialects.mysql import BIGINT
from app.db.base import Base
from app.core.time import now

class Competition(Base):
    __tablename__ = "competitions"
    __table_args__ = (
        Index("idx_date_status", "start_date", "end_date", "status"),
    )

    id = Column(BIGINT(unsigned=True), primary_key=True, autoincrement=True)
    type = Column(Enum("weekly", "monthly", name="competition_type"), nullable=False)
    title = Column(String(255), nullable=False)
    description = Column(Text, nullable=True)
    start_date = Column(Date, nullable=False)
    end_date = Column(Date, nullable=False)
    min_participants = Column(Integer, nullable=False, default=2)
    status = Column(
        Enum("upcoming", "active", "completed", "cancelled", name="competition_status"),
        nullable=False,
    )
    rewards_config = Column(JSON, nullable=True)
    created_at = Column(DateTime, nullable=False, default=now)
    updated_at = Column(
        DateTime, nullable=False, default=now, onupdate=now
    )