from sqlalchemy import Column, String, DateTime, ForeignKey, Index, Boolean
from sqlalchemy.dialects.mysql import BIGINT
from app.db.base import Base
from app.core.time import now

class DeviceToken(Base):
    __tablename__ = "device_tokens"
    
    id = Column(BIGINT(unsigned=True), primary_key=True, autoincrement=True)
    user_id = Column(BIGINT(unsigned=True), ForeignKey("users.id", ondelete="CASCADE"), nullable=False)
    device_token = Column(String(255), nullable=False)
    device_type = Column(String(20), nullable=False)  # 'ios', 'android', 'web'
    is_active = Column(Boolean, default=True, nullable=False)
    created_at = Column(DateTime, nullable=False, default=now)
    updated_at = Column(DateTime, nullable=False, default=now, onupdate=now)
    
    __table_args__ = (
        Index("idx_user_device", "user_id", "device_token", unique=True),
        Index("idx_device_token", "device_token"),
    ) 