# app/models/friendship.py
from sqlalchemy import (
    Column,
    DateTime,
    Enum,
    UniqueConstraint,
    Index,
    ForeignKey,
    func,
)
from sqlalchemy.dialects.mysql import BIGINT
from app.core.time import now
from app.db.base import Base

class Friendship(Base):
    __tablename__ = "friendships"
    __table_args__ = (
        UniqueConstraint("user_id", "friend_id", name="uk_friendship"),
        Index("idx_status", "status"),
    )

    id = Column(BIGINT(unsigned=True), primary_key=True, autoincrement=True)
    user_id = Column(BIGINT(unsigned=True), ForeignKey("users.id", ondelete="CASCADE"), nullable=False)
    friend_id = Column(BIGINT(unsigned=True), ForeignKey("users.id", ondelete="CASCADE"), nullable=False)
    status = Column(
        Enum("pending", "accepted", "blocked", name="friendship_status"),
        nullable=False,
        default="pending",
    )
    created_at = Column(DateTime, nullable=False, default=now)
    updated_at = Column(
        DateTime, nullable=False, default=now, onupdate=now
    )