# app/models/message.py
from sqlalchemy import Column, Text, DateTime, ForeignKey, func, Boolean
from sqlalchemy.dialects.mysql import BIGINT
from app.db.base import Base
from app.core.time import now

class Message(Base):
    __tablename__ = "messages"

    id = Column(BIGINT(unsigned=True), primary_key=True, autoincrement=True)
    sender_id = Column(BIGINT(unsigned=True), ForeignKey("users.id", ondelete="CASCADE"), nullable=False)
    receiver_id = Column(BIGINT(unsigned=True), ForeignKey("users.id", ondelete="CASCADE"), nullable=False)
    content = Column(Text, nullable=False)
    sent_at = Column(DateTime, nullable=False, default=now)
    is_read = Column(Boolean, nullable=False, default=False)