# app/models/notification.py
from sqlalchemy import Column, String, Text, DateTime, JSON, Index, ForeignKey
from sqlalchemy.dialects.mysql import BIGINT
from app.db.base import Base
from app.core.time import now
from app.schemas.notification import PushNotificationRequest

class Notification(Base):
    __tablename__ = "notifications"
    __table_args__ = (
        Index("idx_user_read", "user_id", "read_at"),
        Index("idx_type", "type"),
    )

    id = Column(BIGINT(unsigned=True), primary_key=True, autoincrement=True)
    user_id = Column(BIGINT(unsigned=True), ForeignKey("users.id", ondelete="CASCADE"), nullable=False)
    type = Column(String(50), nullable=False)
    title = Column(String(255), nullable=False)
    message = Column(Text, nullable=False)
    data = Column(JSON, nullable=True)
    read_at = Column(DateTime, nullable=True)
    expires_at = Column(DateTime, nullable=True)
    created_at = Column(DateTime, nullable=False, default=now)