# app/models/password_reset.py
from sqlalchemy import Column, Integer, String, DateTime, ForeignKey, Boolean
from sqlalchemy.dialects.mysql import BIGINT
from app.core.time import now
from app.db.base import Base

class PasswordReset(Base):
    __tablename__ = "password_reset"
    
    id = Column(BIGINT(unsigned=True), primary_key=True, index=True)
    user_id = Column(BIGINT(unsigned=True), ForeignKey("users.id"), nullable=False)
    reset_code = Column(String(6), index=True, nullable=False)
    is_valid = Column(Integer, nullable=False, default=1)
    created_at = Column(DateTime, default=now)