from sqlalchemy import (
    Column,
    String,
    DECIMAL,
    Enum,
    DateTime,
    ForeignKey,
)
from sqlalchemy.dialects.mysql import BIGINT
from app.core.time import now
from app.db.base import Base

class Payment(Base):
    __tablename__ = "payments"

    id = Column(BIGINT(unsigned=True), primary_key=True, autoincrement=True)
    user_id = Column(BIGINT(unsigned=True), ForeignKey("users.id", ondelete="CASCADE"), nullable=False)
    transaction_id = Column(String(100), nullable=False)
    amount = Column(DECIMAL(10, 2), nullable=False)
    currency = Column(String(5), nullable=False, default="USD")
    status = Column(
        Enum("pending", "completed", "failed", name="payment_status"),
        nullable=False,
        default="pending",
    )
    payment_date = Column(DateTime, nullable=True)
    created_at = Column(DateTime, nullable=False, default=now)
