# app/models/point_transaction.py
from sqlalchemy import (
    Column,
    Integer,
    String,
    Enum,
    DateTime,
    ForeignKey,
)
from sqlalchemy.dialects.mysql import BIGINT
from app.core.time import now
from app.db.base import Base

class PointTransaction(Base):
    __tablename__ = "point_transactions"

    id = Column(BIGINT(unsigned=True), primary_key=True, autoincrement=True)
    user_id = Column(BIGINT(unsigned=True), ForeignKey("users.id", ondelete="CASCADE"), nullable=False)
    transaction_type = Column(
        Enum("step", "achievement", "referral_bonus", "referral_chain", "redeem", "admin_adjust", "step_conversion", "point_game", "etc", name="transaction_type"),
        nullable=False,
    )
    amount = Column(Integer, nullable=False)  # Positive for credits, negative for debits
    description = Column(String(255), nullable=True)
    created_at = Column(DateTime, nullable=False, default=now)