# app/models/shopping_cart.py
from sqlalchemy import Column, ForeignKey, DateTime, func
from sqlalchemy.dialects.mysql import BIGINT
from sqlalchemy.orm import relationship
from app.db.base import Base

class ShoppingCart(Base):
    __tablename__ = "shopping_carts"

    id = Column(BIGINT(unsigned=True), primary_key=True, autoincrement=True)
    user_id = Column(BIGINT(unsigned=True), ForeignKey("users.id", ondelete="CASCADE"), nullable=False)
    created_at = Column(DateTime, nullable=False, default=func.now())
    updated_at = Column(DateTime, nullable=False, default=func.now(), onupdate=func.now())

    # This property allows retrieval of the associated cart items.
    items = relationship("CartItem", back_populates="shopping_cart", cascade="all, delete-orphan")
