# app/models/step_record.py
from sqlalchemy import (
    Column,
    Date,
    Integer,
    Float,
    Boolean,
    String,
    DateTime,
    UniqueConstraint,
    Index,
    ForeignKey,
)
from sqlalchemy.dialects.mysql import BIGINT
from app.db.base import Base
from app.core.time import now

class StepRecord(Base):
    __tablename__ = "step_records"
    __table_args__ = (
        UniqueConstraint("user_id", "record_date", name="uk_user_date"),
        Index("idx_record_date", "record_date"),
    )

    id = Column(BIGINT(unsigned=True), primary_key=True, autoincrement=True)
    user_id = Column(BIGINT(unsigned=True), ForeignKey("users.id", ondelete="CASCADE"), nullable=False)
    record_date = Column(Date, nullable=False)
    steps_count = Column(Integer, nullable=False)
    points_earned = Column(Integer, nullable=False)
    calories_burned = Column(Float, nullable=True)
    distance_km = Column(Float, nullable=True)
    goal_achieved = Column(Boolean, default=False)
    sync_source = Column(String(50), nullable=True)
    created_at = Column(DateTime, nullable=False, default=now)
    updated_at = Column(DateTime, nullable=False, default=now, onupdate=now)