# app/models/user_points.py
from sqlalchemy import Column, Integer, DateTime, ForeignKey, UniqueConstraint
from sqlalchemy.dialects.mysql import BIGINT
from app.db.base import Base
from app.core.time import now

class UserPoints(Base):
    __tablename__ = "user_points"
    __table_args__ = (UniqueConstraint("user_id", name="uq_user_points_user"),)

    id = Column(BIGINT(unsigned=True), primary_key=True, autoincrement=True)
    user_id = Column(BIGINT(unsigned=True), ForeignKey("users.id", ondelete="CASCADE"), nullable=False)
    total_points = Column(Integer, nullable=False, default=0)
    updated_at = Column(
        DateTime, nullable=False, default=now, onupdate=now
    )