# app/models/user_referral.py
from sqlalchemy.dialects.mysql import BIGINT
from sqlalchemy import Column, DateTime, ForeignKey, Boolean
from app.db.base import Base
from app.core.time import now

class UserReferral(Base):
    __tablename__ = "user_referrals"

    id = Column(BIGINT(unsigned=True), primary_key=True, autoincrement=True)
    # referrer_user_id: 추천을 하는 사용자의 ID (추천인)
    referrer_user_id = Column(BIGINT(unsigned=True), ForeignKey("users.id", ondelete="CASCADE"), nullable=False)
    # referred_user_id: 추천받은 사용자의 ID (추천 대상자)
    referred_user_id = Column(BIGINT(unsigned=True), ForeignKey("users.id", ondelete="CASCADE"), nullable=False)
    # referral_date: 추천이 발생한 날짜 및 시간 (기본값은 현재 시간)
    referral_date = Column(DateTime, nullable=False, default=now)
    # awarded: 추천 보너스 지급 여부 (지급되었으면 True, 미지급이면 False)
    awarded = Column(Boolean, nullable=False, default=False)