from datetime import datetime
from pydantic import BaseModel
from typing import Optional

class AdminSettingBase(BaseModel):
    setting_name: str
    setting_value: str
    country_code: Optional[str] = None

class AdminSettingCreate(AdminSettingBase):
    pass

class AdminSettingUpdate(BaseModel):
    setting_value: str
    country_code: Optional[str] = None

class AdminSettingResponse(AdminSettingBase):
    id: int
    updated_at: datetime

    class Config:
        orm_mode = True 