from typing import Optional
from datetime import datetime
from pydantic import BaseModel, Field

class DeviceTokenBase(BaseModel):
    device_token: str
    device_type: str

class DeviceTokenCreate(DeviceTokenBase):
    pass

class DeviceTokenUpdate(DeviceTokenBase):
    is_active: bool = True

class DeviceTokenInDB(DeviceTokenBase):
    id: int
    user_id: int
    is_active: bool
    created_at: datetime
    updated_at: datetime

    class Config:
        from_attributes = True

class DeviceTokenResponse(DeviceTokenInDB):
    pass 