# app/schemas/friendship.py
from datetime import datetime
from pydantic import BaseModel
from typing import Optional

class FriendshipResponse(BaseModel):
    id: int
    requested_by: int       # The user that sent the friend request
    requested_to: int       # The user that received the friend request
    friend_id: int          # The "other" user (for convenience, same as requested_to when incoming)
    first_name: str
    last_name: str
    profile_image: Optional[str] = None
    status: str
    is_request_received: bool  # True if current user is the recipient (i.e. friend request received)
    created_at: datetime
    updated_at: Optional[datetime]

    class Config:
        orm_mode = True
