# app/schemas/message.py
from datetime import datetime
from pydantic import BaseModel

class MessageBase(BaseModel):
    receiver_id: int
    content: str

class MessageCreate(MessageBase):
    pass

class MessageResponse(MessageBase):
    id: int
    sender_id: int
    sent_at: datetime
    is_read: bool

    class Config:
        orm_mode = True
