# app/schemas/notification.py
from typing import Optional, Dict, Any
from datetime import datetime
from pydantic import BaseModel, Field

class NotificationBase(BaseModel):
    user_id: int
    type: str
    title: str
    message: str
    data: Optional[dict] = None
    read_at: Optional[datetime] = None
    expires_at: Optional[datetime] = None
    created_at: datetime

class NotificationInDB(NotificationBase):
    id: int

    class Config:
        from_attributes = True

class NotificationResponse(NotificationInDB):
    pass

class PushNotificationRequest(BaseModel):
    title: str
    message: str = Field(..., alias="body")
    notification_type: Optional[str] = None
    data: Optional[Dict[str, Any]] = None

    class Config:
        allow_population_by_field_name = True 