from datetime import datetime
from pydantic import BaseModel

class PasswordResetBase(BaseModel):
    user_id: int
    reset_code: str
    is_valid: int
    created_at: datetime

class PasswordResetCreate(PasswordResetBase):
    # 보통 생성 요청시 created_at은 자동으로 처리되므로, 제외할 수 있습니다.
    pass

class PasswordResetResponse(PasswordResetBase):
    id: int

    class Config:
        orm_mode = True