# app/schemas/product.py
from pydantic import BaseModel
from typing import Optional, Any, List
from datetime import datetime

class ProductBase(BaseModel):
    name: str
    description: str
    category_id: int
    points_required: int
    stock: int
    specifications: Optional[Any] = None
    status: int

class ProductCreate(ProductBase):
    pass

class ProductResponse(ProductBase):
    id: int
    created_at: datetime
    updated_at: datetime
    thumbnail: Optional[str] = None

    class Config:
        from_attributes = True

    @classmethod
    def from_orm(cls, product):
        instance = cls.model_validate(product)
        instance.thumbnail = product.thumbnail
        return instance

class ProductDetailResponse(BaseModel):
    id: int
    name: str
    description: str
    price: int
    images: List[str]
    status: int
    inStock: bool
    stockCount: int
    created_at: datetime
    updated_at: datetime

    class Config:
        orm_mode = True
