from pydantic import BaseModel
from typing import Optional
from datetime import datetime

class ProductCategoryBase(BaseModel):
    code: str
    name: str
    description: Optional[str] = None

class ProductCategoryResponse(ProductCategoryBase):
    id: int
    created_at: datetime
    updated_at: datetime

    class Config:
        orm_mode = True 